// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Weekday Request Builder.
 */
public class BaseWorkbookFunctionsWeekdayRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsWeekday
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsWeekdayRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final com.google.gson.JsonElement serialNumber, final com.google.gson.JsonElement returnType) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("serialNumber", serialNumber);
        mBodyParams.put("returnType", returnType);
    }

    /**
     * Creates the IWorkbookFunctionsWeekdayRequest
     *
     * @return The IWorkbookFunctionsWeekdayRequest instance
     */
    public IWorkbookFunctionsWeekdayRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsWeekdayRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsWeekdayRequest instance
     */
    public IWorkbookFunctionsWeekdayRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFunctionsWeekdayRequest request = new WorkbookFunctionsWeekdayRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("serialNumber")) {
            request.mBody.serialNumber = getParameter("serialNumber");
        }

        if (hasParameter("returnType")) {
            request.mBody.returnType = getParameter("returnType");
        }

        return request;
    }
}
