// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Rept Request Builder.
 */
public class BaseWorkbookFunctionsReptRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsRept
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsReptRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final com.google.gson.JsonElement text, final com.google.gson.JsonElement numberTimes) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("text", text);
        mBodyParams.put("numberTimes", numberTimes);
    }

    /**
     * Creates the IWorkbookFunctionsReptRequest
     *
     * @return The IWorkbookFunctionsReptRequest instance
     */
    public IWorkbookFunctionsReptRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsReptRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsReptRequest instance
     */
    public IWorkbookFunctionsReptRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFunctionsReptRequest request = new WorkbookFunctionsReptRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("text")) {
            request.mBody.text = getParameter("text");
        }

        if (hasParameter("numberTimes")) {
            request.mBody.numberTimes = getParameter("numberTimes");
        }

        return request;
    }
}
