// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions If Request Builder.
 */
public class BaseWorkbookFunctionsIfRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsIf
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsIfRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final com.google.gson.JsonElement logicalTest, final com.google.gson.JsonElement valueIfTrue, final com.google.gson.JsonElement valueIfFalse) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("logicalTest", logicalTest);
        mBodyParams.put("valueIfTrue", valueIfTrue);
        mBodyParams.put("valueIfFalse", valueIfFalse);
    }

    /**
     * Creates the IWorkbookFunctionsIfRequest
     *
     * @return The IWorkbookFunctionsIfRequest instance
     */
    public IWorkbookFunctionsIfRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsIfRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsIfRequest instance
     */
    public IWorkbookFunctionsIfRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFunctionsIfRequest request = new WorkbookFunctionsIfRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("logicalTest")) {
            request.mBody.logicalTest = getParameter("logicalTest");
        }

        if (hasParameter("valueIfTrue")) {
            request.mBody.valueIfTrue = getParameter("valueIfTrue");
        }

        if (hasParameter("valueIfFalse")) {
            request.mBody.valueIfFalse = getParameter("valueIfFalse");
        }

        return request;
    }
}
