// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Erf Request Builder.
 */
public class BaseWorkbookFunctionsErfRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsErf
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsErfRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final com.google.gson.JsonElement lowerLimit, final com.google.gson.JsonElement upperLimit) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("lowerLimit", lowerLimit);
        mBodyParams.put("upperLimit", upperLimit);
    }

    /**
     * Creates the IWorkbookFunctionsErfRequest
     *
     * @return The IWorkbookFunctionsErfRequest instance
     */
    public IWorkbookFunctionsErfRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsErfRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsErfRequest instance
     */
    public IWorkbookFunctionsErfRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFunctionsErfRequest request = new WorkbookFunctionsErfRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("lowerLimit")) {
            request.mBody.lowerLimit = getParameter("lowerLimit");
        }

        if (hasParameter("upperLimit")) {
            request.mBody.upperLimit = getParameter("upperLimit");
        }

        return request;
    }
}
