// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Confidence_Norm Request Builder.
 */
public class BaseWorkbookFunctionsConfidence_NormRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsConfidence_Norm
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsConfidence_NormRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final com.google.gson.JsonElement alpha, final com.google.gson.JsonElement standardDev, final com.google.gson.JsonElement size) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("alpha", alpha);
        mBodyParams.put("standardDev", standardDev);
        mBodyParams.put("size", size);
    }

    /**
     * Creates the IWorkbookFunctionsConfidence_NormRequest
     *
     * @return The IWorkbookFunctionsConfidence_NormRequest instance
     */
    public IWorkbookFunctionsConfidence_NormRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsConfidence_NormRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsConfidence_NormRequest instance
     */
    public IWorkbookFunctionsConfidence_NormRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFunctionsConfidence_NormRequest request = new WorkbookFunctionsConfidence_NormRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("alpha")) {
            request.mBody.alpha = getParameter("alpha");
        }

        if (hasParameter("standardDev")) {
            request.mBody.standardDev = getParameter("standardDev");
        }

        if (hasParameter("size")) {
            request.mBody.size = getParameter("size");
        }

        return request;
    }
}
