// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Filter Apply Font Color Filter Request Builder.
 */
public class BaseWorkbookFilterApplyFontColorFilterRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFilterApplyFontColorFilter
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFilterApplyFontColorFilterRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final String color) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("color", color);
    }

    /**
     * Creates the IWorkbookFilterApplyFontColorFilterRequest
     *
     * @return The IWorkbookFilterApplyFontColorFilterRequest instance
     */
    public IWorkbookFilterApplyFontColorFilterRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFilterApplyFontColorFilterRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFilterApplyFontColorFilterRequest instance
     */
    public IWorkbookFilterApplyFontColorFilterRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFilterApplyFontColorFilterRequest request = new WorkbookFilterApplyFontColorFilterRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("color")) {
            request.mBody.color = getParameter("color");
        }

        return request;
    }
}
