// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// This file is available for extending, afterwards please submit a pull request.

/**
 * The class for the User Assign License Request Builder.
 */
public class UserAssignLicenseRequestBuilder extends BaseUserAssignLicenseRequestBuilder implements IUserAssignLicenseRequestBuilder {

    /**
     * The request builder for this UserAssignLicense
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public UserAssignLicenseRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final List<AssignedLicense> addLicenses, final List<java.util.UUID> removeLicenses) {
        super(requestUrl, client, requestOptions, addLicenses, removeLicenses);
    }
}
