// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Inference Classification Override Collection Request Builder.
 */
public class BaseInferenceClassificationOverrideCollectionRequestBuilder extends BaseRequestBuilder implements IBaseInferenceClassificationOverrideCollectionRequestBuilder {

    /**
     * The request builder for this collection of InferenceClassification
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseInferenceClassificationOverrideCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> options) {
        super(requestUrl, client, options);
    }

    public IInferenceClassificationOverrideCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IInferenceClassificationOverrideCollectionRequest buildRequest(final List<Option> options) {
        return new InferenceClassificationOverrideCollectionRequest(getRequestUrl(), getClient(), options);
    }

    public IInferenceClassificationOverrideRequestBuilder byId(final String id) {
        return new InferenceClassificationOverrideRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }
}
