// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Attachment Collection Request.
 */
public class BaseAttachmentCollectionRequest extends BaseCollectionRequest<BaseAttachmentCollectionResponse, IAttachmentCollectionPage> implements IBaseAttachmentCollectionRequest {

    /**
     * The request builder for this collection of Attachment
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseAttachmentCollectionRequest(final String requestUrl, IBaseClient client, final List<Option> options) {
        super(requestUrl, client, options, BaseAttachmentCollectionResponse.class, IAttachmentCollectionPage.class);
    }

    public void get(final ICallback<IAttachmentCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IAttachmentCollectionPage get() throws ClientException {
        final BaseAttachmentCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Attachment newAttachment, final ICallback<Attachment> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new AttachmentRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest()
            .post(newAttachment, callback);
    }

    public Attachment post(final Attachment newAttachment) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new AttachmentRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest()
            .post(newAttachment);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IAttachmentCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (AttachmentCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IAttachmentCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (AttachmentCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IAttachmentCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (AttachmentCollectionRequest)this;
    }

    public IAttachmentCollectionPage buildFromResponse(final BaseAttachmentCollectionResponse response) {
        final IAttachmentCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new AttachmentCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final AttachmentCollectionPage page = new AttachmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
