/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IPermissionCollectionPage;
import com.microsoft.graph.extensions.IPermissionCollectionRequest;
import com.microsoft.graph.extensions.Permission;
import com.microsoft.graph.extensions.PermissionCollectionPage;
import com.microsoft.graph.extensions.PermissionCollectionRequest;
import com.microsoft.graph.extensions.PermissionCollectionRequestBuilder;
import com.microsoft.graph.extensions.PermissionRequestBuilder;
import com.microsoft.graph.generated.BasePermissionCollectionResponse;
import com.microsoft.graph.generated.IBasePermissionCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BasePermissionCollectionRequest
extends BaseCollectionRequest<BasePermissionCollectionResponse, IPermissionCollectionPage>
implements IBasePermissionCollectionRequest {
    public BasePermissionCollectionRequest(String requestUrl, IBaseClient client, List<Option> options) {
        super(requestUrl, client, options, BasePermissionCollectionResponse.class, IPermissionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IPermissionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BasePermissionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPermissionCollectionPage get() throws ClientException {
        BasePermissionCollectionResponse response = (BasePermissionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Permission newPermission, ICallback<Permission> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PermissionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newPermission, callback);
    }

    @Override
    public Permission post(Permission newPermission) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PermissionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newPermission);
    }

    @Override
    public IPermissionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (PermissionCollectionRequest)this;
    }

    @Override
    public IPermissionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (PermissionCollectionRequest)this;
    }

    @Override
    public IPermissionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (PermissionCollectionRequest)this;
    }

    public IPermissionCollectionPage buildFromResponse(BasePermissionCollectionResponse response) {
        PermissionCollectionRequestBuilder builder = response.nextLink != null ? new PermissionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PermissionCollectionPage page = new PermissionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

