/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.DirectoryRoleTemplate;
import com.microsoft.graph.extensions.DirectoryRoleTemplateCollectionPage;
import com.microsoft.graph.extensions.DirectoryRoleTemplateCollectionRequest;
import com.microsoft.graph.extensions.DirectoryRoleTemplateCollectionRequestBuilder;
import com.microsoft.graph.extensions.DirectoryRoleTemplateRequestBuilder;
import com.microsoft.graph.extensions.IDirectoryRoleTemplateCollectionPage;
import com.microsoft.graph.extensions.IDirectoryRoleTemplateCollectionRequest;
import com.microsoft.graph.generated.BaseDirectoryRoleTemplateCollectionResponse;
import com.microsoft.graph.generated.IBaseDirectoryRoleTemplateCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseDirectoryRoleTemplateCollectionRequest
extends BaseCollectionRequest<BaseDirectoryRoleTemplateCollectionResponse, IDirectoryRoleTemplateCollectionPage>
implements IBaseDirectoryRoleTemplateCollectionRequest {
    public BaseDirectoryRoleTemplateCollectionRequest(String requestUrl, IBaseClient client, List<Option> options) {
        super(requestUrl, client, options, BaseDirectoryRoleTemplateCollectionResponse.class, IDirectoryRoleTemplateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDirectoryRoleTemplateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDirectoryRoleTemplateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDirectoryRoleTemplateCollectionPage get() throws ClientException {
        BaseDirectoryRoleTemplateCollectionResponse response = (BaseDirectoryRoleTemplateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DirectoryRoleTemplate newDirectoryRoleTemplate, ICallback<DirectoryRoleTemplate> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DirectoryRoleTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newDirectoryRoleTemplate, callback);
    }

    @Override
    public DirectoryRoleTemplate post(DirectoryRoleTemplate newDirectoryRoleTemplate) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DirectoryRoleTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newDirectoryRoleTemplate);
    }

    @Override
    public IDirectoryRoleTemplateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (DirectoryRoleTemplateCollectionRequest)this;
    }

    @Override
    public IDirectoryRoleTemplateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (DirectoryRoleTemplateCollectionRequest)this;
    }

    @Override
    public IDirectoryRoleTemplateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (DirectoryRoleTemplateCollectionRequest)this;
    }

    public IDirectoryRoleTemplateCollectionPage buildFromResponse(BaseDirectoryRoleTemplateCollectionResponse response) {
        DirectoryRoleTemplateCollectionRequestBuilder builder = response.nextLink != null ? new DirectoryRoleTemplateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DirectoryRoleTemplateCollectionPage page = new DirectoryRoleTemplateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

