// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Entity Request Builder.
 */
public class BaseEntityRequestBuilder extends BaseRequestBuilder implements IBaseEntityRequestBuilder {

    /**
     * The request builder for the Entity
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseEntityRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> options) {
        super(requestUrl, client, options);
    }

    /**
     * Creates the request
     */
    public IEntityRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific options instead of the existing options
     */
    public IEntityRequest buildRequest(final List<Option> options) {
        return new EntityRequest(getRequestUrl(), getClient(), options);
    }


    public IDirectoryObjectRequestBuilder directoryObject() {
        return new DirectoryObjectRequestBuilder(getRequestUrlWithAdditionalSegment("directoryObject"), getClient(), null);
    }

    public IConversationThreadRequestBuilder conversationThread() {
        return new ConversationThreadRequestBuilder(getRequestUrlWithAdditionalSegment("conversationThread"), getClient(), null);
    }

    public ICalendarRequestBuilder calendar() {
        return new CalendarRequestBuilder(getRequestUrlWithAdditionalSegment("calendar"), getClient(), null);
    }

    public IOutlookItemRequestBuilder outlookItem() {
        return new OutlookItemRequestBuilder(getRequestUrlWithAdditionalSegment("outlookItem"), getClient(), null);
    }

    public IConversationRequestBuilder conversation() {
        return new ConversationRequestBuilder(getRequestUrlWithAdditionalSegment("conversation"), getClient(), null);
    }

    public IProfilePhotoRequestBuilder profilePhoto() {
        return new ProfilePhotoRequestBuilder(getRequestUrlWithAdditionalSegment("profilePhoto"), getClient(), null);
    }

    public IDriveRequestBuilder drive() {
        return new DriveRequestBuilder(getRequestUrlWithAdditionalSegment("drive"), getClient(), null);
    }

    public ISubscribedSkuRequestBuilder subscribedSku() {
        return new SubscribedSkuRequestBuilder(getRequestUrlWithAdditionalSegment("subscribedSku"), getClient(), null);
    }

    public IMailFolderRequestBuilder mailFolder() {
        return new MailFolderRequestBuilder(getRequestUrlWithAdditionalSegment("mailFolder"), getClient(), null);
    }

    public ICalendarGroupRequestBuilder calendarGroup() {
        return new CalendarGroupRequestBuilder(getRequestUrlWithAdditionalSegment("calendarGroup"), getClient(), null);
    }

    public IContactFolderRequestBuilder contactFolder() {
        return new ContactFolderRequestBuilder(getRequestUrlWithAdditionalSegment("contactFolder"), getClient(), null);
    }

    public IAttachmentRequestBuilder attachment() {
        return new AttachmentRequestBuilder(getRequestUrlWithAdditionalSegment("attachment"), getClient(), null);
    }

    public IDriveItemRequestBuilder driveItem() {
        return new DriveItemRequestBuilder(getRequestUrlWithAdditionalSegment("driveItem"), getClient(), null);
    }

    public IPermissionRequestBuilder permission() {
        return new PermissionRequestBuilder(getRequestUrlWithAdditionalSegment("permission"), getClient(), null);
    }

    public IThumbnailSetRequestBuilder thumbnailSet() {
        return new ThumbnailSetRequestBuilder(getRequestUrlWithAdditionalSegment("thumbnailSet"), getClient(), null);
    }
}
