// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Directory Object Check Member Groups Request.
 */
public class BaseDirectoryObjectCheckMemberGroupsRequest extends BaseRequest implements IBaseDirectoryObjectCheckMemberGroupsRequest {
    protected final DirectoryObjectCheckMemberGroupsBody mBody;

    /**
     * The request for this DirectoryObjectCheckMemberGroups
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseDirectoryObjectCheckMemberGroupsRequest(final String requestUrl, final IBaseClient client, final List<Option> options, final List<String> groupIds) {
        super(requestUrl, client, options, String.class);
        mBody = new DirectoryObjectCheckMemberGroupsBody();
        mBody.groupIds = groupIds;
    }

    public void post(final ICallback<String> callback) {
        send(HttpMethod.POST, callback, mBody);
    }

    public String post() throws ClientException {
        return send(HttpMethod.POST, mBody);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IDirectoryObjectCheckMemberGroupsRequest select(final String value) {
        getQueryOptions().add(new QueryOption("select", value));
        return (DirectoryObjectCheckMemberGroupsRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IDirectoryObjectCheckMemberGroupsRequest top(final int value) {
        getQueryOptions().add(new QueryOption("top", value+""));
        return (DirectoryObjectCheckMemberGroupsRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IDirectoryObjectCheckMemberGroupsRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("expand", value));
        return (DirectoryObjectCheckMemberGroupsRequest)this;
    }
}
