/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.microsoft.graph.logger.DefaultLogger;
import com.microsoft.graph.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;

public class FallBackEnumTypeAdapter
implements TypeAdapterFactory {
    private static final String NO_KNOWN_VALUE = "unexpectedValue";
    private final ILogger mLogger = new DefaultLogger();

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (!rawType.isEnum()) {
            return null;
        }
        final HashMap enumValues = new HashMap();
        for (Object constant : rawType.getEnumConstants()) {
            enumValues.put(constant.toString(), constant);
        }
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                if (value == null) {
                    out.nullValue();
                } else {
                    out.value(value.toString());
                }
            }

            public T read(JsonReader reader) throws IOException {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    return null;
                }
                String value = reader.nextString();
                Object incoming = enumValues.get(value);
                if (incoming == null) {
                    FallBackEnumTypeAdapter.this.mLogger.logDebug(String.format("The following value %s could not be recognized as a member of the enum", value));
                    return enumValues.get(FallBackEnumTypeAdapter.NO_KNOWN_VALUE);
                }
                return incoming;
            }
        };
    }
}

