/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.GsonFactory;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;

public class DefaultSerializer
implements ISerializer {
    private final Gson mGson;
    private final ILogger mLogger;

    public DefaultSerializer(ILogger logger) {
        this.mLogger = logger;
        this.mGson = GsonFactory.getGsonInstance(logger);
    }

    @Override
    public <T> T deserializeObject(String inputString, Class<T> clazz) {
        Object jsonObject = this.mGson.fromJson(inputString, clazz);
        if (jsonObject instanceof IJsonBackedObject) {
            this.mLogger.logDebug("Deserializing type " + clazz.getSimpleName());
            IJsonBackedObject jsonBackedObject = (IJsonBackedObject)jsonObject;
            jsonBackedObject.setRawObject(this, (JsonObject)this.mGson.fromJson(inputString, JsonObject.class));
        } else {
            this.mLogger.logDebug("Deserializing a non-IJsonBackedObject type " + clazz.getSimpleName());
        }
        return (T)jsonObject;
    }

    @Override
    public <T> String serializeObject(T serializableObject) {
        this.mLogger.logDebug("Serializing type " + serializableObject.getClass().getSimpleName());
        return this.mGson.toJson(serializableObject);
    }
}

