/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseRequestBuilder
implements IRequestBuilder {
    private final IBaseClient mClient;
    private final String mRequestUrl;
    private final List<Option> mOptions = new ArrayList<Option>();
    private final IJsonBackedObject mBody;

    public BaseRequestBuilder(String requestUrl, IBaseClient client, List<Option> options) {
        this.mRequestUrl = requestUrl;
        this.mClient = client;
        this.mBody = null;
        if (options != null) {
            this.mOptions.addAll(options);
        }
    }

    public BaseRequestBuilder(String requestUrl, IJsonBackedObject body, IBaseClient client, List<Option> options) {
        this.mRequestUrl = requestUrl;
        this.mClient = client;
        this.mBody = body;
        if (options != null) {
            this.mOptions.addAll(options);
        }
    }

    @Override
    public IBaseClient getClient() {
        return this.mClient;
    }

    @Override
    public String getRequestUrl() {
        return this.mRequestUrl;
    }

    public List<Option> getOptions() {
        return Collections.unmodifiableList(this.mOptions);
    }

    @Override
    public String getRequestUrlWithAdditionalSegment(String urlSegment) {
        return this.mRequestUrl + "/" + urlSegment;
    }

    public String getRequestUrlWithAdditionalParameter(String parameter) {
        return this.mRequestUrl + "('" + parameter + "')";
    }
}

