/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IPostCollectionPage;
import com.microsoft.graph.extensions.IPostCollectionRequest;
import com.microsoft.graph.extensions.Post;
import com.microsoft.graph.extensions.PostCollectionPage;
import com.microsoft.graph.extensions.PostCollectionRequest;
import com.microsoft.graph.extensions.PostCollectionRequestBuilder;
import com.microsoft.graph.extensions.PostRequestBuilder;
import com.microsoft.graph.generated.BasePostCollectionResponse;
import com.microsoft.graph.generated.IBasePostCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BasePostCollectionRequest
extends BaseCollectionRequest<BasePostCollectionResponse, IPostCollectionPage>
implements IBasePostCollectionRequest {
    public BasePostCollectionRequest(String requestUrl, IBaseClient client, List<Option> options) {
        super(requestUrl, client, options, BasePostCollectionResponse.class, IPostCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IPostCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BasePostCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPostCollectionPage get() throws ClientException {
        BasePostCollectionResponse response = (BasePostCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Post newPost, ICallback<Post> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PostRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newPost, callback);
    }

    @Override
    public Post post(Post newPost) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PostRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newPost);
    }

    @Override
    public IPostCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("expand", value));
        return (PostCollectionRequest)this;
    }

    @Override
    public IPostCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("select", value));
        return (PostCollectionRequest)this;
    }

    @Override
    public IPostCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("top", value + ""));
        return (PostCollectionRequest)this;
    }

    public IPostCollectionPage buildFromResponse(BasePostCollectionResponse response) {
        PostCollectionRequestBuilder builder = response.nextLink != null ? new PostCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PostCollectionPage page = new PostCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

