/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.extensions.Attachment;
import com.microsoft.graph.extensions.AttachmentCollectionPage;
import com.microsoft.graph.extensions.Importance;
import com.microsoft.graph.extensions.ItemBody;
import com.microsoft.graph.extensions.OutlookItem;
import com.microsoft.graph.extensions.Recipient;
import com.microsoft.graph.generated.BaseAttachmentCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class BaseMessage
extends OutlookItem
implements IJsonBackedObject {
    @SerializedName(value="receivedDateTime")
    public Calendar receivedDateTime;
    @SerializedName(value="sentDateTime")
    public Calendar sentDateTime;
    @SerializedName(value="hasAttachments")
    public Boolean hasAttachments;
    @SerializedName(value="internetMessageId")
    public String internetMessageId;
    @SerializedName(value="subject")
    public String subject;
    @SerializedName(value="body")
    public ItemBody body;
    @SerializedName(value="bodyPreview")
    public String bodyPreview;
    @SerializedName(value="importance")
    public Importance importance;
    @SerializedName(value="parentFolderId")
    public String parentFolderId;
    @SerializedName(value="sender")
    public Recipient sender;
    @SerializedName(value="from")
    public Recipient from;
    @SerializedName(value="toRecipients")
    public List<Recipient> toRecipients;
    @SerializedName(value="ccRecipients")
    public List<Recipient> ccRecipients;
    @SerializedName(value="bccRecipients")
    public List<Recipient> bccRecipients;
    @SerializedName(value="replyTo")
    public List<Recipient> replyTo;
    @SerializedName(value="conversationId")
    public String conversationId;
    @SerializedName(value="uniqueBody")
    public ItemBody uniqueBody;
    @SerializedName(value="isDeliveryReceiptRequested")
    public Boolean isDeliveryReceiptRequested;
    @SerializedName(value="isReadReceiptRequested")
    public Boolean isReadReceiptRequested;
    @SerializedName(value="isRead")
    public Boolean isRead;
    @SerializedName(value="isDraft")
    public Boolean isDraft;
    @SerializedName(value="webLink")
    public String webLink;
    public transient AttachmentCollectionPage attachments;
    private transient JsonObject mRawObject;
    private transient ISerializer mSerializer;

    public BaseMessage() {
        this.oDataType = "microsoft.graph.message";
    }

    @Override
    public JsonObject getRawObject() {
        return this.mRawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.mSerializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        this.mSerializer = serializer;
        this.mRawObject = json;
        if (json.has("attachments")) {
            BaseAttachmentCollectionResponse response = new BaseAttachmentCollectionResponse();
            if (json.has("attachments@odata.nextLink")) {
                response.nextLink = json.get("attachments@odata.nextLink").getAsString();
            }
            JsonObject[] sourceArray = serializer.deserializeObject(json.get("attachments").toString(), JsonObject[].class);
            Attachment[] array = new Attachment[sourceArray.length];
            for (int i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Attachment.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.attachments = new AttachmentCollectionPage(response, null);
        }
    }
}

