/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core;

import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.concurrency.DefaultExecutors;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.IClientConfig;
import com.microsoft.graph.http.DefaultHttpProvider;
import com.microsoft.graph.http.IHttpProvider;
import com.microsoft.graph.logger.DefaultLogger;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.DefaultSerializer;
import com.microsoft.graph.serializer.ISerializer;

public abstract class DefaultClientConfig
implements IClientConfig {
    private IAuthenticationProvider mAuthenticationProvider;
    private IExecutors mExecutors;
    private DefaultHttpProvider mHttpProvider;
    private ILogger mLogger;
    private DefaultSerializer mSerializer;

    public static IClientConfig createWithAuthenticationProvider(IAuthenticationProvider authenticationProvider) {
        DefaultClientConfig config = new DefaultClientConfig(){};
        config.mAuthenticationProvider = authenticationProvider;
        config.getLogger().logDebug("Using provided auth provider " + authenticationProvider.getClass().getSimpleName());
        return config;
    }

    @Override
    public IAuthenticationProvider getAuthenticationProvider() {
        return this.mAuthenticationProvider;
    }

    @Override
    public IHttpProvider getHttpProvider() {
        if (this.mHttpProvider == null) {
            this.mHttpProvider = new DefaultHttpProvider(this.getSerializer(), this.getAuthenticationProvider(), this.getExecutors(), this.getLogger());
            this.mLogger.logDebug("Created DefaultHttpProvider");
        }
        return this.mHttpProvider;
    }

    @Override
    public ISerializer getSerializer() {
        if (this.mSerializer == null) {
            this.mSerializer = new DefaultSerializer(this.getLogger());
            this.mLogger.logDebug("Created DefaultSerializer");
        }
        return this.mSerializer;
    }

    @Override
    public IExecutors getExecutors() {
        if (this.mExecutors == null) {
            this.mExecutors = new DefaultExecutors(this.getLogger());
            this.mLogger.logDebug("Created DefaultExecutors");
        }
        return this.mExecutors;
    }

    @Override
    public ILogger getLogger() {
        if (this.mLogger == null) {
            this.mLogger = new DefaultLogger();
            this.mLogger.logDebug("Created DefaultLogger");
        }
        return this.mLogger;
    }
}

