// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Reference Attachment Request.
 */
public class BaseReferenceAttachmentRequest extends AttachmentRequest implements IBaseReferenceAttachmentRequest {

    /**
     * The request for the ReferenceAttachment
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseReferenceAttachmentRequest(final String requestUrl,
            final IBaseClient client,
            final List<Option> options,
            final Class responseClass) {
        super(requestUrl, client, options, responseClass);
    }

    /**
     * Gets the ReferenceAttachment from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<ReferenceAttachment> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the ReferenceAttachment from the service
     * @return The ReferenceAttachment from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public ReferenceAttachment get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this ReferenceAttachment with a source
     * @param sourceReferenceAttachment The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final ReferenceAttachment sourceReferenceAttachment, final ICallback<ReferenceAttachment> callback) {
        send(HttpMethod.PATCH, callback, sourceReferenceAttachment);
    }

    /**
     * Patches this ReferenceAttachment with a source
     * @param sourceReferenceAttachment The source object with updates
     * @return The updated ReferenceAttachment
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public ReferenceAttachment patch(final ReferenceAttachment sourceReferenceAttachment) throws ClientException {
        return send(HttpMethod.PATCH, sourceReferenceAttachment);
    }

    /**
     * Creates a ReferenceAttachment with a new object
     * @param newReferenceAttachment The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final ReferenceAttachment newReferenceAttachment, final ICallback<ReferenceAttachment> callback) {
        send(HttpMethod.POST, callback, newReferenceAttachment);
    }

    /**
     * Creates a ReferenceAttachment with a new object
     * @param newReferenceAttachment The new object to create
     * @return The created ReferenceAttachment
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public ReferenceAttachment post(final ReferenceAttachment newReferenceAttachment) throws ClientException {
        return send(HttpMethod.POST, newReferenceAttachment);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IReferenceAttachmentRequest select(final String value) {
         getQueryOptions().add(new QueryOption("select", value));
         return (ReferenceAttachmentRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IReferenceAttachmentRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("expand", value));
         return (ReferenceAttachmentRequest)this;
     }
}
