// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Post Request Builder.
 */
public class BasePostRequestBuilder extends BaseRequestBuilder implements IBasePostRequestBuilder {

    /**
     * The request builder for the Post
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BasePostRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> options) {
        super(requestUrl, client, options);
    }

    /**
     * Creates the request
     */
    public IPostRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific options instead of the existing options
     */
    public IPostRequest buildRequest(final List<Option> options) {
        return new PostRequest(getRequestUrl(), getClient(), options);
    }


    /**
     * Gets the request builder for Post.
     */
    public IPostRequestBuilder getInReplyTo() {
        return new PostRequestBuilder(getRequestUrlWithAdditionalSegment("inReplyTo"), getClient(), null);
    }
    public IAttachmentCollectionRequestBuilder getAttachments() {
        return new AttachmentCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("attachments"), getClient(), null);
    }

    public IAttachmentRequestBuilder getAttachments(final String id) {
        return new AttachmentRequestBuilder(getRequestUrlWithAdditionalSegment("attachments") + "/" + id, getClient(), null);
    }

    public IPostForwardRequestBuilder getForward(final String comment, final List<Recipient> toRecipients) {
        return new PostForwardRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.Forward"), getClient(), null, comment, toRecipients);
    }

    public IPostReplyRequestBuilder getReply(final Post post) {
        return new PostReplyRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.Reply"), getClient(), null, post);
    }
}
