// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

import com.google.gson.JsonObject;
import com.google.gson.annotations.*;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Organization.
 */
public class BaseOrganization extends DirectoryObject implements IJsonBackedObject {


	public BaseOrganization(){
		oDataType = "microsoft.graph.organization";
	}
	
    /**
     * The Assigned Plans.
     */
    @SerializedName("assignedPlans")
    public List<AssignedPlan> assignedPlans;

    /**
     * The Business Phones.
     */
    @SerializedName("businessPhones")
    public List<String> businessPhones;

    /**
     * The City.
     */
    @SerializedName("city")
    public String city;

    /**
     * The Country.
     */
    @SerializedName("country")
    public String country;

    /**
     * The Country Letter Code.
     */
    @SerializedName("countryLetterCode")
    public String countryLetterCode;

    /**
     * The Display Name.
     */
    @SerializedName("displayName")
    public String displayName;

    /**
     * The Marketing Notification Emails.
     */
    @SerializedName("marketingNotificationEmails")
    public List<String> marketingNotificationEmails;

    /**
     * The On Premises Last Sync Date Time.
     */
    @SerializedName("onPremisesLastSyncDateTime")
    public java.util.Calendar onPremisesLastSyncDateTime;

    /**
     * The On Premises Sync Enabled.
     */
    @SerializedName("onPremisesSyncEnabled")
    public Boolean onPremisesSyncEnabled;

    /**
     * The Postal Code.
     */
    @SerializedName("postalCode")
    public String postalCode;

    /**
     * The Preferred Language.
     */
    @SerializedName("preferredLanguage")
    public String preferredLanguage;

    /**
     * The Provisioned Plans.
     */
    @SerializedName("provisionedPlans")
    public List<ProvisionedPlan> provisionedPlans;

    /**
     * The Security Compliance Notification Mails.
     */
    @SerializedName("securityComplianceNotificationMails")
    public List<String> securityComplianceNotificationMails;

    /**
     * The Security Compliance Notification Phones.
     */
    @SerializedName("securityComplianceNotificationPhones")
    public List<String> securityComplianceNotificationPhones;

    /**
     * The State.
     */
    @SerializedName("state")
    public String state;

    /**
     * The Street.
     */
    @SerializedName("street")
    public String street;

    /**
     * The Technical Notification Mails.
     */
    @SerializedName("technicalNotificationMails")
    public List<String> technicalNotificationMails;

    /**
     * The Verified Domains.
     */
    @SerializedName("verifiedDomains")
    public List<VerifiedDomain> verifiedDomains;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
