// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Group Request.
 */
public class BaseGroupRequest extends DirectoryObjectRequest implements IBaseGroupRequest {

    /**
     * The request for the Group
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseGroupRequest(final String requestUrl,
            final IBaseClient client,
            final List<Option> options,
            final Class responseClass) {
        super(requestUrl, client, options, responseClass);
    }

    /**
     * Gets the Group from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<Group> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Group from the service
     * @return The Group from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Group get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this Group with a source
     * @param sourceGroup The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final Group sourceGroup, final ICallback<Group> callback) {
        send(HttpMethod.PATCH, callback, sourceGroup);
    }

    /**
     * Patches this Group with a source
     * @param sourceGroup The source object with updates
     * @return The updated Group
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Group patch(final Group sourceGroup) throws ClientException {
        return send(HttpMethod.PATCH, sourceGroup);
    }

    /**
     * Creates a Group with a new object
     * @param newGroup The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final Group newGroup, final ICallback<Group> callback) {
        send(HttpMethod.POST, callback, newGroup);
    }

    /**
     * Creates a Group with a new object
     * @param newGroup The new object to create
     * @return The created Group
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Group post(final Group newGroup) throws ClientException {
        return send(HttpMethod.POST, newGroup);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IGroupRequest select(final String value) {
         getQueryOptions().add(new QueryOption("select", value));
         return (GroupRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IGroupRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("expand", value));
         return (GroupRequest)this;
     }
}
