// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Drive Recent Request.
 */
public class BaseDriveRecentRequest extends BaseRequest implements IBaseDriveRecentRequest {

    /**
     * The request for this DriveRecent
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param options The options for this request
     */
    public BaseDriveRecentRequest(final String requestUrl, final IBaseClient client, final List<Option> options) {
        super(requestUrl, client, options, DriveItem.class);

    }

    /**
     * Gets the Drive
     *
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<Drive> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Drive
     *
     * @return The Drive
     * @throws ClientException An exception occurs if there was an error while the request was sent.
     */
    public Drive get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IDriveRecentRequest select(final String value) {
        getQueryOptions().add(new QueryOption("select", value));
        return (DriveRecentRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IDriveRecentRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("expand", value));
        return (DriveRecentRequest)this;
    }
}
