/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ItemActivity;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IItemActivityCollectionPage;
import com.microsoft.graph.requests.extensions.IItemActivityCollectionRequest;
import com.microsoft.graph.requests.extensions.ItemActivityCollectionPage;
import com.microsoft.graph.requests.extensions.ItemActivityCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ItemActivityCollectionResponse;
import com.microsoft.graph.requests.extensions.ItemActivityRequestBuilder;
import java.util.List;

public class ItemActivityCollectionRequest
extends BaseCollectionRequest<ItemActivityCollectionResponse, IItemActivityCollectionPage>
implements IItemActivityCollectionRequest {
    public ItemActivityCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemActivityCollectionResponse.class, IItemActivityCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IItemActivityCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ItemActivityCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IItemActivityCollectionPage get() throws ClientException {
        ItemActivityCollectionResponse response = (ItemActivityCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ItemActivity newItemActivity, ICallback<ItemActivity> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ItemActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newItemActivity, callback);
    }

    @Override
    public ItemActivity post(ItemActivity newItemActivity) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ItemActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newItemActivity);
    }

    @Override
    public IItemActivityCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IItemActivityCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IItemActivityCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IItemActivityCollectionPage buildFromResponse(ItemActivityCollectionResponse response) {
        ItemActivityCollectionRequestBuilder builder = response.nextLink != null ? new ItemActivityCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ItemActivityCollectionPage page = new ItemActivityCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

