// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Role Definition Collection Request.
 */
public class RoleDefinitionCollectionRequest extends BaseCollectionRequest<RoleDefinitionCollectionResponse, IRoleDefinitionCollectionPage> implements IRoleDefinitionCollectionRequest {

    /**
     * The request builder for this collection of RoleDefinition
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RoleDefinitionCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RoleDefinitionCollectionResponse.class, IRoleDefinitionCollectionPage.class);
    }

    public void get(final ICallback<IRoleDefinitionCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IRoleDefinitionCollectionPage get() throws ClientException {
        final RoleDefinitionCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final RoleDefinition newRoleDefinition, final ICallback<RoleDefinition> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new RoleDefinitionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newRoleDefinition, callback);
    }

    public RoleDefinition post(final RoleDefinition newRoleDefinition) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new RoleDefinitionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newRoleDefinition);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IRoleDefinitionCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (RoleDefinitionCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IRoleDefinitionCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (RoleDefinitionCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IRoleDefinitionCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (RoleDefinitionCollectionRequest)this;
    }

    public IRoleDefinitionCollectionPage buildFromResponse(final RoleDefinitionCollectionResponse response) {
        final IRoleDefinitionCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new RoleDefinitionCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final RoleDefinitionCollectionPage page = new RoleDefinitionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
