// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.MuteParticipantOperation;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Mute Participant Operation Request.
 */
public interface IMuteParticipantOperationRequest extends IHttpRequest {

    /**
     * Gets the MuteParticipantOperation from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<MuteParticipantOperation> callback);

    /**
     * Gets the MuteParticipantOperation from the service
     *
     * @return the MuteParticipantOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MuteParticipantOperation get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<MuteParticipantOperation> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this MuteParticipantOperation with a source
     *
     * @param sourceMuteParticipantOperation the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final MuteParticipantOperation sourceMuteParticipantOperation, final ICallback<MuteParticipantOperation> callback);

    /**
     * Patches this MuteParticipantOperation with a source
     *
     * @param sourceMuteParticipantOperation the source object with updates
     * @return the updated MuteParticipantOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MuteParticipantOperation patch(final MuteParticipantOperation sourceMuteParticipantOperation) throws ClientException;

    /**
     * Posts a MuteParticipantOperation with a new object
     *
     * @param newMuteParticipantOperation the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final MuteParticipantOperation newMuteParticipantOperation, final ICallback<MuteParticipantOperation> callback);

    /**
     * Posts a MuteParticipantOperation with a new object
     *
     * @param newMuteParticipantOperation the new object to create
     * @return the created MuteParticipantOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MuteParticipantOperation post(final MuteParticipantOperation newMuteParticipantOperation) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IMuteParticipantOperationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IMuteParticipantOperationRequest expand(final String value);

}

