// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Activity History Item Collection Request Builder.
 */
public class ActivityHistoryItemCollectionRequestBuilder extends BaseRequestBuilder implements IActivityHistoryItemCollectionRequestBuilder {

    /**
     * The request builder for this collection of UserActivity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ActivityHistoryItemCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IActivityHistoryItemCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IActivityHistoryItemCollectionRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new ActivityHistoryItemCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IActivityHistoryItemRequestBuilder byId(final String id) {
        return new ActivityHistoryItemRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }


}
