// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.DataPolicyOperationStatus;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Data Policy Operation.
 */
public class DataPolicyOperation extends Entity implements IJsonBackedObject {


    /**
     * The Completed Date Time.
     * Represents when the request for this data policy operation was completed, in UTC time, using the ISO 8601 format. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Null until the operation completes.
     */
    @SerializedName("completedDateTime")
    @Expose
    public java.util.Calendar completedDateTime;

    /**
     * The Status.
     * Possible values are: notStarted, running, complete, failed, unknownFutureValue.
     */
    @SerializedName("status")
    @Expose
    public DataPolicyOperationStatus status;

    /**
     * The Storage Location.
     * The URL location to where data is being exported for export requests.
     */
    @SerializedName("storageLocation")
    @Expose
    public String storageLocation;

    /**
     * The User Id.
     * The id for the user on whom the operation is performed.
     */
    @SerializedName("userId")
    @Expose
    public String userId;

    /**
     * The Submitted Date Time.
     * Represents when the request for this data operation was submitted, in UTC time, using the ISO 8601 format. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @SerializedName("submittedDateTime")
    @Expose
    public java.util.Calendar submittedDateTime;

    /**
     * The Progress.
     * Specifies the progress of an operation.
     */
    @SerializedName("progress")
    @Expose
    public Double progress;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
