/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.intent;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class IntentTrigger
implements AutoCloseable {
    private SafeHandle triggerHandle = null;

    public static IntentTrigger fromPhrase(String string) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(IntentTrigger.createFromPhrase(intRef, string));
        return new IntentTrigger(intRef);
    }

    public static IntentTrigger fromModel(SafeHandle safeHandle) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(IntentTrigger.createFromLanguageUnderstandingModel(intRef, safeHandle, null));
        return new IntentTrigger(intRef);
    }

    public static IntentTrigger fromModel(SafeHandle safeHandle, String string) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(IntentTrigger.createFromLanguageUnderstandingModel(intRef, safeHandle, string));
        return new IntentTrigger(intRef);
    }

    @Override
    public void close() {
        if (this.triggerHandle != null) {
            this.triggerHandle.close();
            this.triggerHandle = null;
        }
    }

    public SafeHandle getImpl() {
        return this.triggerHandle;
    }

    private IntentTrigger(IntRef intRef) {
        this.triggerHandle = new SafeHandle(intRef.getValue(), SafeHandleType.IntentTrigger);
    }

    private static final native long createFromPhrase(IntRef var0, String var1);

    private static final native long createFromLanguageUnderstandingModel(IntRef var0, SafeHandle var1, String var2);
}

