/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;

public final class Diagnostics {
    public static void startConsoleLogging(boolean bl) {
        Contracts.throwIfFail(Diagnostics.logConsoleStartLogging(bl));
    }

    public static void startConsoleLogging() {
        Diagnostics.startConsoleLogging(true);
    }

    public static void stopConsoleLogging() {
        Contracts.throwIfFail(Diagnostics.logConsoleStopLogging());
    }

    public static void startMemoryLogging() {
        Contracts.throwIfFail(Diagnostics.logMemoryStartLogging());
    }

    public static void stopMemoryLogging() {
        Contracts.throwIfFail(Diagnostics.logMemoryStopLogging());
    }

    public static void dumpMemoryLog(String string, String string2, boolean bl, boolean bl2) {
        Contracts.throwIfFail(Diagnostics.logMemoryDump(string, string2, bl, bl2));
    }

    public static void dumpMemoryLogOnExit(String string, String string2, boolean bl, boolean bl2) {
        Contracts.throwIfFail(Diagnostics.logMemoryDumpOnExit(string, string2, bl, bl2));
    }

    public static void startFileLogging(String string, boolean bl) {
        Contracts.throwIfNullOrWhitespace(string, "filename");
        Contracts.throwIfFail(Diagnostics.logFileStartLogging(string, bl));
    }

    public static void stopFileLogging() {
        Contracts.throwIfFail(Diagnostics.logFileStopLogging());
    }

    private static final native long logConsoleStartLogging(boolean var0);

    private static final native long logConsoleStopLogging();

    private static final native long logMemoryStartLogging();

    private static final native long logMemoryStopLogging();

    private static final native long logMemoryDump(String var0, String var1, boolean var2, boolean var3);

    private static final native long logMemoryDumpOnExit(String var0, String var1, boolean var2, boolean var3);

    private static final native long logFileStartLogging(String var0, boolean var1);

    private static final native long logFileStopLogging();

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

