/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.mercadopago.android.px.model.Bin;
import com.mercadopago.android.px.model.CardNumber;
import com.mercadopago.android.px.model.PaymentMethod;
import com.mercadopago.android.px.model.SecurityCode;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Setting
implements Parcelable,
Serializable {
    public static final Parcelable.Creator<Setting> CREATOR = new Parcelable.Creator<Setting>(){

        public Setting createFromParcel(Parcel in) {
            return new Setting(in);
        }

        public Setting[] newArray(int size) {
            return new Setting[size];
        }
    };
    private Bin bin;
    private CardNumber cardNumber;
    private SecurityCode securityCode;

    private Setting(Parcel in) {
        this.bin = (Bin)in.readParcelable(Bin.class.getClassLoader());
        this.cardNumber = (CardNumber)in.readParcelable(CardNumber.class.getClassLoader());
        this.securityCode = (SecurityCode)in.readParcelable(SecurityCode.class.getClassLoader());
    }

    @Nullable
    public static Setting getSettingByBin(Collection<Setting> settings, @Nullable String bin) {
        Setting selectedSetting = null;
        if (settings != null && !settings.isEmpty()) {
            for (Setting setting : settings) {
                if (bin == null || bin.isEmpty() || !bin.matches(setting.getBin().getPattern() + ".*") || setting.getBin().getExclusionPattern() != null && !setting.getBin().getExclusionPattern().isEmpty() && bin.matches(setting.getBin().getExclusionPattern() + ".*")) continue;
                selectedSetting = setting;
            }
        }
        return selectedSetting;
    }

    @Nullable
    public static Setting getSettingByPaymentMethodAndBin(PaymentMethod paymentMethod, String bin) {
        Setting setting = null;
        if (bin == null) {
            if (paymentMethod.getSettings() != null && !paymentMethod.getSettings().isEmpty()) {
                setting = paymentMethod.getSettings().get(0);
            }
        } else {
            List<Setting> settings = paymentMethod.getSettings();
            setting = Setting.getSettingByBin(settings, bin);
        }
        return setting;
    }

    public Bin getBin() {
        return this.bin;
    }

    public void setBin(Bin bin) {
        this.bin = bin;
    }

    public CardNumber getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(CardNumber cardNumber) {
        this.cardNumber = cardNumber;
    }

    public SecurityCode getSecurityCode() {
        return this.securityCode;
    }

    public void setSecurityCode(SecurityCode securityCode) {
        this.securityCode = securityCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.bin, flags);
        dest.writeParcelable((Parcelable)this.cardNumber, flags);
        dest.writeParcelable((Parcelable)this.securityCode, flags);
    }
}

