/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.util;

import android.support.annotation.NonNull;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.style.RelativeSizeSpan;
import com.mercadopago.android.px.internal.util.TextUtil;
import com.mercadopago.android.px.internal.util.textformatter.SuperscriptSpanAdjuster;
import com.mercadopago.android.px.model.Currency;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;

public final class CurrenciesUtil {
    private static final String CURRENCY_ARGENTINA = "ARS";
    private static final String CURRENCY_BRAZIL = "BRL";
    private static final String CURRENCY_CHILE = "CLP";
    private static final String CURRENCY_COLOMBIA = "COP";
    private static final String CURRENCY_MEXICO = "MXN";
    private static final String CURRENCY_VENEZUELA = "VES";
    private static final String CURRENCY_USA = "USD";
    private static final String CURRENCY_PERU = "PEN";
    private static final String CURRENCY_URUGUAY = "UYU";
    private static final String ZERO_DECIMAL = "00";
    private static Map<String, Currency> currenciesList = new HashMap<String, Currency>(){
        {
            this.put(CurrenciesUtil.CURRENCY_ARGENTINA, new Currency(CurrenciesUtil.CURRENCY_ARGENTINA, "Peso argentino", "$", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_BRAZIL, new Currency(CurrenciesUtil.CURRENCY_BRAZIL, "Real", "R$", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_CHILE, new Currency(CurrenciesUtil.CURRENCY_CHILE, "Peso chileno", "$", 0, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_COLOMBIA, new Currency(CurrenciesUtil.CURRENCY_COLOMBIA, "Peso colombiano", "$", 0, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_MEXICO, new Currency(CurrenciesUtil.CURRENCY_MEXICO, "Peso mexicano", "$", 2, Character.valueOf(".".charAt(0)), Character.valueOf(",".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_VENEZUELA, new Currency(CurrenciesUtil.CURRENCY_VENEZUELA, "Bol\u00edvares Soberanos", "BsS", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_USA, new Currency(CurrenciesUtil.CURRENCY_USA, "Dolar americano", "US$", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_PERU, new Currency(CurrenciesUtil.CURRENCY_PERU, "Soles", "S/.", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
            this.put(CurrenciesUtil.CURRENCY_URUGUAY, new Currency(CurrenciesUtil.CURRENCY_URUGUAY, "Peso Uruguayo", "$", 2, Character.valueOf(",".charAt(0)), Character.valueOf(".".charAt(0))));
        }
    };

    private CurrenciesUtil() {
    }

    public static String getLocalizedAmountNoDecimals(BigDecimal truncated, Currency currency) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(currency.getDecimalSeparator().charValue());
        dfs.setGroupingSeparator(currency.getThousandsSeparator().charValue());
        DecimalFormat df = new DecimalFormat();
        df.setDecimalFormatSymbols(dfs);
        df.setMinimumFractionDigits(0);
        df.setMaximumFractionDigits(0);
        return df.format(truncated);
    }

    public static String getLocalizedAmount(@NonNull BigDecimal amount, Currency currency) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(currency.getDecimalSeparator().charValue());
        dfs.setGroupingSeparator(currency.getThousandsSeparator().charValue());
        DecimalFormat df = new DecimalFormat();
        df.setDecimalFormatSymbols(dfs);
        df.setMinimumFractionDigits(currency.getDecimalPlaces());
        df.setMaximumFractionDigits(currency.getDecimalPlaces());
        return df.format(amount);
    }

    public static Spanned getSpannedAmountWithCurrencySymbol(BigDecimal amount, Currency currency) {
        return CurrenciesUtil.getSpannedString(amount, currency, false, true);
    }

    private static String getDecimals(Currency currency, BigDecimal amount) {
        String localizedAmount = CurrenciesUtil.getLocalizedAmount(amount, currency);
        int decimalDivisionIndex = localizedAmount.indexOf(currency.getDecimalSeparator().charValue());
        String decimals = null;
        if (decimalDivisionIndex != -1) {
            decimals = localizedAmount.substring(decimalDivisionIndex + 1);
        }
        return decimals;
    }

    private static Spanned getSpannedString(BigDecimal amount, Currency currency, boolean symbolUp, boolean decimalsUp) {
        String localizedAmount = CurrenciesUtil.getLocalizedAmountWithoutZeroDecimals(currency, amount);
        SpannableStringBuilder spannableAmount = new SpannableStringBuilder((CharSequence)localizedAmount);
        if (decimalsUp && !CurrenciesUtil.hasZeroDecimals(currency, amount)) {
            int fromDecimals = localizedAmount.indexOf(currency.getDecimalSeparator().charValue()) + 1;
            localizedAmount = localizedAmount.replace(String.valueOf(currency.getDecimalSeparator()), " ");
            spannableAmount = new SpannableStringBuilder((CharSequence)localizedAmount);
            CurrenciesUtil.decimalsUp(currency, amount, (Spannable)spannableAmount, fromDecimals);
        }
        if (symbolUp) {
            CurrenciesUtil.symbolUp(currency, localizedAmount, (Spannable)spannableAmount);
        }
        return new SpannedString((CharSequence)spannableAmount);
    }

    @Deprecated
    public static String getLocalizedAmountWithoutZeroDecimals(@NonNull String currencyId, @NonNull BigDecimal amount) {
        return CurrenciesUtil.getLocalizedAmountWithoutZeroDecimals(currenciesList.get(currencyId), amount);
    }

    public static String getLocalizedAmountWithoutZeroDecimals(@NonNull Currency currency, @NonNull BigDecimal amount) {
        Character decimalSeparator;
        int decimalIndex;
        String localized = CurrenciesUtil.getLocalizedAmountWithCurrencySymbol(amount, currency);
        if (CurrenciesUtil.hasZeroDecimals(currency, amount) && (decimalIndex = localized.indexOf((decimalSeparator = currency.getDecimalSeparator()).charValue())) >= 0) {
            localized = localized.substring(0, decimalIndex);
        }
        return localized;
    }

    private static String getLocalizedAmountWithCurrencySymbol(BigDecimal amount, Currency currency) {
        String formattedAmount = CurrenciesUtil.getLocalizedAmount(amount, currency);
        return currency.getSymbol() + " " + formattedAmount;
    }

    private static boolean hasZeroDecimals(Currency currency, BigDecimal amount) {
        String decimals = CurrenciesUtil.getDecimals(currency, amount);
        return ZERO_DECIMAL.equals(decimals) || TextUtil.isEmpty(decimals);
    }

    private static void symbolUp(@NonNull Currency currency, String localizedAmount, Spannable spannableAmount) {
        int fromSymbolPosition = localizedAmount.indexOf(currency.getSymbol());
        int toSymbolPosition = fromSymbolPosition + currency.getSymbol().length();
        spannableAmount.setSpan((Object)new RelativeSizeSpan(0.5f), fromSymbolPosition, toSymbolPosition, 33);
        spannableAmount.setSpan((Object)new SuperscriptSpanAdjuster(0.65f), fromSymbolPosition, toSymbolPosition, 33);
    }

    private static void decimalsUp(Currency currency, BigDecimal amount, Spannable spannableAmount, int fromDecimals) {
        int toDecimals = fromDecimals + CurrenciesUtil.getDecimals(currency, amount).length();
        spannableAmount.setSpan((Object)new RelativeSizeSpan(0.5f), fromDecimals, toDecimals, 33);
        spannableAmount.setSpan((Object)new SuperscriptSpanAdjuster(0.7f), fromDecimals, toDecimals, 33);
    }
}

