/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.internal.core;

import android.os.Parcelable;
import com.mercadopago.android.px.internal.util.ParcelableUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J)\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\n\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/mercadopago/android/px/internal/core/FileManager;", "", "rootCacheDir", "Ljava/io/File;", "(Ljava/io/File;)V", "create", "fileName", "", "exists", "", "file", "readParcelable", "T", "creator", "Landroid/os/Parcelable$Creator;", "(Ljava/io/File;Landroid/os/Parcelable$Creator;)Ljava/lang/Object;", "readText", "removeFile", "writeToFile", "", "fileContent", "Landroid/os/Parcelable;", "services_release"})
public final class FileManager {
    private final File rootCacheDir;

    @NotNull
    public final File create(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        StringBuilder fileNameBuilder = new StringBuilder();
        fileNameBuilder.append(this.rootCacheDir.getPath());
        fileNameBuilder.append(File.separator);
        fileNameBuilder.append(fileName);
        return new File(fileNameBuilder.toString());
    }

    public final synchronized void writeToFile(@NotNull File file, @NotNull String fileContent) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileContent, (String)"fileContent");
        if (!file.exists()) {
            FilesKt.writeText$default((File)file, (String)fileContent, null, (int)2, null);
        }
    }

    public final synchronized void writeToFile(@NotNull File file, @NotNull Parcelable fileContent) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileContent, (String)"fileContent");
        if (!file.exists()) {
            byte[] byArray = ParcelableUtil.marshall(fileContent);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ParcelableUtil.marshall(fileContent)");
            FilesKt.writeBytes((File)file, (byte[])byArray);
        }
    }

    @NotNull
    public final synchronized String readText(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file.exists() ? FilesKt.readText$default((File)file, null, (int)1, null) : "";
    }

    @Nullable
    public final synchronized <T> T readParcelable(@NotNull File file, @NotNull Parcelable.Creator<T> creator) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(creator, (String)"creator");
        return file.exists() ? (T)ParcelableUtil.unmarshall(FilesKt.readBytes((File)file), creator) : null;
    }

    public final synchronized boolean exists(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return file.exists();
    }

    public final synchronized boolean removeFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.exists(file) && file.delete();
    }

    public FileManager(@NotNull File rootCacheDir) {
        Intrinsics.checkParameterIsNotNull((Object)rootCacheDir, (String)"rootCacheDir");
        this.rootCacheDir = rootCacheDir;
    }
}

