/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.services;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mercadopago.android.px.internal.services.BankDealService;
import com.mercadopago.android.px.internal.services.CheckoutService;
import com.mercadopago.android.px.internal.services.DiscountService;
import com.mercadopago.android.px.internal.services.GatewayService;
import com.mercadopago.android.px.internal.services.IdentificationService;
import com.mercadopago.android.px.internal.services.InstallmentService;
import com.mercadopago.android.px.internal.services.InstructionsClient;
import com.mercadopago.android.px.internal.services.IssuersService;
import com.mercadopago.android.px.internal.services.PaymentService;
import com.mercadopago.android.px.internal.services.PreferenceService;
import com.mercadopago.android.px.internal.util.LocaleUtil;
import com.mercadopago.android.px.internal.util.RetrofitUtil;
import com.mercadopago.android.px.internal.util.TextUtil;
import com.mercadopago.android.px.model.BankDeal;
import com.mercadopago.android.px.model.CardToken;
import com.mercadopago.android.px.model.Discount;
import com.mercadopago.android.px.model.IdentificationType;
import com.mercadopago.android.px.model.Installment;
import com.mercadopago.android.px.model.Instructions;
import com.mercadopago.android.px.model.Issuer;
import com.mercadopago.android.px.model.Payment;
import com.mercadopago.android.px.model.PaymentMethod;
import com.mercadopago.android.px.model.PaymentMethodSearch;
import com.mercadopago.android.px.model.ProcessingMode;
import com.mercadopago.android.px.model.SavedCardToken;
import com.mercadopago.android.px.model.SavedESCCardToken;
import com.mercadopago.android.px.model.Site;
import com.mercadopago.android.px.model.Token;
import com.mercadopago.android.px.model.requests.SecurityCodeIntent;
import com.mercadopago.android.px.preferences.CheckoutPreference;
import com.mercadopago.android.px.services.Callback;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import retrofit2.Retrofit;

public class MercadoPagoServices {
    final Context context;
    final String publicKey;
    final String privateKey;
    private final ProcessingMode processingMode;
    private final Retrofit retrofitClient;

    public MercadoPagoServices(@NonNull Context context, @NonNull String publicKey, @Nullable String privateKey) {
        this.context = context;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.processingMode = ProcessingMode.AGGREGATOR;
        this.retrofitClient = RetrofitUtil.getRetrofitClient(context);
    }

    public void getCheckoutPreference(String checkoutPreferenceId, Callback<CheckoutPreference> callback) {
        PreferenceService service = (PreferenceService)this.retrofitClient.create(PreferenceService.class);
        service.getPreference(checkoutPreferenceId, this.publicKey).enqueue(callback);
    }

    public void getInstructions(Long paymentId, String paymentTypeId, Callback<Instructions> callback) {
        InstructionsClient service = (InstructionsClient)this.retrofitClient.create(InstructionsClient.class);
        service.getInstructions("v1", LocaleUtil.getLanguage(this.context), paymentId, this.publicKey, this.privateKey, paymentTypeId).enqueue(callback);
    }

    @Deprecated
    public void getPaymentMethodSearch(BigDecimal amount, List<String> excludedPaymentTypes, List<String> excludedPaymentMethods, List<String> cardsWithEsc, Site site, @Nullable Integer differentialPricing, Callback<PaymentMethodSearch> callback) {
        CheckoutService service = (CheckoutService)this.retrofitClient.create(CheckoutService.class);
        String separator = ",";
        String excludedPaymentTypesAppended = this.getListAsString(excludedPaymentTypes, ",");
        String excludedPaymentMethodsAppended = this.getListAsString(excludedPaymentMethods, ",");
        String cardsWithEscAppended = this.getListAsString(cardsWithEsc, ",");
        service.getPaymentMethodSearch("v1", LocaleUtil.getLanguage(this.context), this.publicKey, amount, excludedPaymentTypesAppended, excludedPaymentMethodsAppended, site.getId(), this.processingMode.asQueryParamName(), cardsWithEscAppended, differentialPricing, null, false, this.privateKey).enqueue(callback);
    }

    public void createToken(CardToken cardToken, Callback<Token> callback) {
        cardToken.setDevice(this.context);
        GatewayService service = (GatewayService)this.retrofitClient.create(GatewayService.class);
        service.createToken(this.publicKey, this.privateKey, cardToken).enqueue(callback);
    }

    public void createToken(SavedCardToken savedCardToken, Callback<Token> callback) {
        savedCardToken.setDevice(this.context);
        GatewayService service = (GatewayService)this.retrofitClient.create(GatewayService.class);
        service.createToken(this.publicKey, this.privateKey, savedCardToken).enqueue(callback);
    }

    public void createToken(SavedESCCardToken savedESCCardToken, Callback<Token> callback) {
        savedESCCardToken.setDevice(this.context);
        GatewayService service = (GatewayService)this.retrofitClient.create(GatewayService.class);
        service.createToken(this.publicKey, this.privateKey, savedESCCardToken).enqueue(callback);
    }

    public void cloneToken(String tokenId, Callback<Token> callback) {
        GatewayService service = (GatewayService)this.retrofitClient.create(GatewayService.class);
        service.cloneToken(tokenId, this.publicKey, this.privateKey).enqueue(callback);
    }

    public void putSecurityCode(String tokenId, SecurityCodeIntent securityCodeIntent, Callback<Token> callback) {
        GatewayService service = (GatewayService)this.retrofitClient.create(GatewayService.class);
        service.updateToken(tokenId, this.publicKey, this.privateKey, securityCodeIntent).enqueue(callback);
    }

    public void getBankDeals(Callback<List<BankDeal>> callback) {
        BankDealService service = (BankDealService)this.retrofitClient.create(BankDealService.class);
        service.getBankDeals(this.publicKey, this.privateKey, LocaleUtil.getLanguage(this.context)).enqueue(callback);
    }

    public void getIdentificationTypes(Callback<List<IdentificationType>> callback) {
        if (TextUtil.isNotEmpty(this.privateKey)) {
            this.getIdentificationTypes(this.privateKey, callback);
        } else {
            IdentificationService service = (IdentificationService)this.retrofitClient.create(IdentificationService.class);
            service.getIdentificationTypesNonAuthUser(this.publicKey);
        }
    }

    @Deprecated
    public void getIdentificationTypes(String accessToken, Callback<List<IdentificationType>> callback) {
        IdentificationService service = (IdentificationService)this.retrofitClient.create(IdentificationService.class);
        service.getIdentificationTypesForAuthUser(accessToken).enqueue(callback);
    }

    public void getInstallments(String bin, BigDecimal amount, Long issuerId, String paymentMethodId, @Nullable Integer differentialPricingId, Callback<List<Installment>> callback) {
        InstallmentService service = (InstallmentService)this.retrofitClient.create(InstallmentService.class);
        service.getInstallments("v1", this.publicKey, this.privateKey, bin, amount, issuerId, paymentMethodId, LocaleUtil.getLanguage(this.context), this.processingMode.asQueryParamName(), differentialPricingId).enqueue(callback);
    }

    public void getIssuers(String paymentMethodId, String bin, Callback<List<Issuer>> callback) {
        IssuersService service = (IssuersService)this.retrofitClient.create(IssuersService.class);
        service.getIssuers("v1", this.publicKey, this.privateKey, paymentMethodId, bin, this.processingMode.asQueryParamName()).enqueue(callback);
    }

    public void getPaymentMethods(Callback<List<PaymentMethod>> callback) {
        CheckoutService service = (CheckoutService)this.retrofitClient.create(CheckoutService.class);
        service.getPaymentMethods("v1", this.publicKey, this.privateKey).enqueue(callback);
    }

    @Deprecated
    public void getDirectDiscount(String amount, String payerEmail, Callback<Discount> callback) {
        DiscountService service = (DiscountService)this.retrofitClient.create(DiscountService.class);
        service.getDiscount(this.publicKey, amount, payerEmail).enqueue(callback);
    }

    @Deprecated
    public void getCodeDiscount(String amount, String payerEmail, String couponCode, Callback<Discount> callback) {
        DiscountService service = (DiscountService)this.retrofitClient.create(DiscountService.class);
        service.getDiscount(this.publicKey, amount, payerEmail, couponCode).enqueue(callback);
    }

    @Deprecated
    public void createPayment(String transactionId, Map<String, Object> paymentData, @NonNull Map<String, String> query, Callback<Payment> callback) {
        this.createPayment(transactionId, paymentData, callback);
    }

    public void createPayment(String transactionId, Map<String, Object> paymentData, Callback<Payment> callback) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("public_key", this.publicKey);
        if (TextUtil.isNotEmpty(this.privateKey)) {
            queryParams.put("access_token", this.privateKey);
        }
        PaymentService paymentService = (PaymentService)this.retrofitClient.create(PaymentService.class);
        paymentService.createPayment("v1", transactionId, paymentData, queryParams).enqueue(callback);
    }

    private String getListAsString(List<String> list, String separator) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null) {
            for (String typeId : list) {
                stringBuilder.append(typeId);
                if (typeId.equals(list.get(list.size() - 1))) continue;
                stringBuilder.append(separator);
            }
        }
        return stringBuilder.toString();
    }

    public void createPreference(@NonNull CheckoutPreference.Builder preferenceBuilder, @NonNull Callback<CheckoutPreference> callback) {
        PreferenceService preferenceService = (PreferenceService)this.retrofitClient.create(PreferenceService.class);
        preferenceService.createPreference(preferenceBuilder.build(), this.privateKey).enqueue(callback);
    }
}

