/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.mercadopago.android.px.internal.util.ParcelableUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class Campaign
implements Serializable,
Parcelable {
    private final String id;
    private final String codeType;
    private final BigDecimal maxCouponAmount;
    @SerializedName(value="max_redeem_per_user")
    private final int maxRedeemPerUser;
    @SerializedName(value="end_date")
    private final Date endDate;
    private static final String CODE_TYPE_SINGLE = "single";
    private static final String CODE_TYPE_MULTIPLE = "multiple";
    private static final String CODE_TYPE_NONE = "none";
    public static final Parcelable.Creator<Campaign> CREATOR = new Parcelable.Creator<Campaign>(){

        public Campaign createFromParcel(Parcel in) {
            return new Campaign(in);
        }

        public Campaign[] newArray(int size) {
            return new Campaign[size];
        }
    };

    Campaign(Builder builder) {
        this.id = builder.id;
        this.maxCouponAmount = builder.maxCouponAmount;
        this.codeType = builder.codeType;
        this.maxRedeemPerUser = builder.maxRedeemPerUser;
        this.endDate = builder.endDate;
    }

    public int getMaxRedeemPerUser() {
        return this.maxRedeemPerUser;
    }

    public String getId() {
        return this.id;
    }

    public BigDecimal getMaxCouponAmount() {
        return this.maxCouponAmount;
    }

    public String getCodeType() {
        return this.codeType;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getPrettyEndDate() {
        return DateFormat.getDateInstance(1, Locale.getDefault()).format(this.endDate);
    }

    public boolean hasMaxCouponAmount() {
        return this.maxCouponAmount != null && BigDecimal.ZERO.compareTo(this.maxCouponAmount) < 0;
    }

    public boolean hasEndDate() {
        return this.endDate != null;
    }

    public boolean isSingleCodeDiscountCampaign() {
        return CODE_TYPE_SINGLE.contains(this.codeType);
    }

    public boolean isMultipleCodeDiscountCampaign() {
        return CODE_TYPE_MULTIPLE.contains(this.codeType);
    }

    public boolean isDirectDiscountCampaign() {
        return CODE_TYPE_NONE.contains(this.codeType);
    }

    public boolean isAlwaysOnDiscount() {
        return this.maxRedeemPerUser > 1;
    }

    Campaign(Parcel in) {
        this.id = in.readString();
        this.maxCouponAmount = ParcelableUtil.getOptionalBigDecimal(in);
        this.codeType = in.readString();
        this.maxRedeemPerUser = in.readInt();
        this.endDate = new Date(in.readLong());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        ParcelableUtil.writeOptional(dest, this.maxCouponAmount);
        dest.writeString(this.codeType);
        dest.writeInt(this.maxRedeemPerUser);
        dest.writeLong(this.endDate.getTime());
    }

    public String getCampaignTermsUrl() {
        return String.format(Locale.US, "https://api.mercadolibre.com/campaigns/%s/terms_and_conditions?format_type=html", this.id);
    }

    public static final class Builder {
        @NonNull
        final String id;
        BigDecimal maxCouponAmount = BigDecimal.ZERO;
        @Nullable
        String codeType;
        int maxRedeemPerUser = 1;
        @Nullable
        Date endDate;

        public Builder(@NonNull String id) {
            this.id = id;
        }

        public Builder setMaxCouponAmount(BigDecimal maxCouponAmount) {
            this.maxCouponAmount = maxCouponAmount;
            return this;
        }

        public Builder setCodeType(@Nullable String codeType) {
            this.codeType = codeType;
            return this;
        }

        public Builder setMaxRedeemPerUser(int maxRedeemPerUser) {
            this.maxRedeemPerUser = maxRedeemPerUser;
            return this;
        }

        public Builder setEndDate(Date endDate) {
            this.endDate = endDate;
            return this;
        }

        public Campaign build() {
            return new Campaign(this);
        }
    }
}

