/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model.internal;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mercadopago.android.px.model.IPayment;
import com.mercadopago.android.px.model.IPaymentDescriptor;
import com.mercadopago.android.px.model.IPaymentDescriptorHandler;

public final class IParcelablePaymentDescriptor
implements IPaymentDescriptor,
Parcelable {
    private final String paymentTypeId;
    private final String paymentMethodId;
    @Nullable
    private final Long id;
    @Nullable
    private final String statementDescription;
    private final String paymentStatus;
    private final String paymentStatusDetail;
    public static final Parcelable.Creator<IParcelablePaymentDescriptor> CREATOR = new Parcelable.Creator<IParcelablePaymentDescriptor>(){

        public IParcelablePaymentDescriptor createFromParcel(Parcel in) {
            return new IParcelablePaymentDescriptor(in);
        }

        public IParcelablePaymentDescriptor[] newArray(int size) {
            return new IParcelablePaymentDescriptor[size];
        }
    };

    private IParcelablePaymentDescriptor(@NonNull String paymentStatus, @NonNull String paymentStatusDetail, @NonNull String paymentTypeId, @NonNull String paymentMethodId, @Nullable Long id, @Nullable String statementDescription) {
        this.paymentTypeId = paymentTypeId;
        this.paymentMethodId = paymentMethodId;
        this.id = id;
        this.statementDescription = statementDescription;
        this.paymentStatus = paymentStatus;
        this.paymentStatusDetail = paymentStatusDetail;
    }

    public static IParcelablePaymentDescriptor with(@NonNull IPayment iPayment) {
        return new IParcelablePaymentDescriptor(iPayment.getPaymentStatus(), iPayment.getPaymentStatusDetail(), null, null, iPayment.getId(), iPayment.getStatementDescription());
    }

    public static IParcelablePaymentDescriptor with(@NonNull IPaymentDescriptor iPaymentDescriptor) {
        return new IParcelablePaymentDescriptor(iPaymentDescriptor.getPaymentStatus(), iPaymentDescriptor.getPaymentStatusDetail(), iPaymentDescriptor.getPaymentTypeId(), iPaymentDescriptor.getPaymentMethodId(), iPaymentDescriptor.getId(), iPaymentDescriptor.getStatementDescription());
    }

    private IParcelablePaymentDescriptor(Parcel in) {
        this.paymentTypeId = in.readString();
        this.paymentMethodId = in.readString();
        this.id = in.readByte() == 0 ? null : Long.valueOf(in.readLong());
        this.statementDescription = in.readString();
        this.paymentStatus = in.readString();
        this.paymentStatusDetail = in.readString();
    }

    @Override
    @NonNull
    public String getPaymentTypeId() {
        return this.paymentTypeId;
    }

    @Override
    @NonNull
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    @Override
    public void process(@NonNull IPaymentDescriptorHandler handler) {
        handler.visit(this);
    }

    @Override
    @Nullable
    public Long getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getStatementDescription() {
        return this.statementDescription;
    }

    @Override
    @NonNull
    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    @Override
    @NonNull
    public String getPaymentStatusDetail() {
        return this.paymentStatusDetail;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.paymentTypeId);
        dest.writeString(this.paymentMethodId);
        if (this.id == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeLong(this.id.longValue());
        }
        dest.writeString(this.statementDescription);
        dest.writeString(this.paymentStatus);
        dest.writeString(this.paymentStatusDetail);
    }
}

