/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mercadopago.android.px.internal.util.CurrenciesUtil;
import com.mercadopago.android.px.internal.util.ParcelableUtil;
import com.mercadopago.android.px.internal.util.TextUtil;
import java.io.Serializable;
import java.math.BigDecimal;

public class Discount
implements Serializable,
Parcelable {
    private final String id;
    private final String name;
    private final String currencyId;
    private final BigDecimal percentOff;
    private final BigDecimal amountOff;
    private final BigDecimal couponAmount;
    public static final Parcelable.Creator<Discount> CREATOR = new Parcelable.Creator<Discount>(){

        public Discount createFromParcel(Parcel in) {
            return new Discount(in);
        }

        public Discount[] newArray(int size) {
            return new Discount[size];
        }
    };

    Discount(Builder builder) {
        this.id = builder.id;
        this.currencyId = builder.currencyId;
        this.couponAmount = builder.couponAmount;
        this.name = builder.name;
        this.percentOff = builder.percentOff;
        this.amountOff = builder.amountOff;
    }

    @Nullable
    public static Discount replaceWith(@Nullable Discount originalDiscount, @Nullable String discountToken) {
        if (originalDiscount != null && !TextUtil.isEmpty(discountToken)) {
            return new Builder(discountToken, originalDiscount.getCurrencyId(), originalDiscount.getCouponAmount()).setAmountOff(originalDiscount.getAmountOff()).setPercentOff(originalDiscount.getPercentOff()).setName(originalDiscount.getName()).build();
        }
        return null;
    }

    public BigDecimal getAmountOff() {
        return this.amountOff;
    }

    public BigDecimal getCouponAmount() {
        return this.couponAmount;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getPercentOff() {
        return this.percentOff;
    }

    public BigDecimal getAmountWithDiscount(BigDecimal amount) {
        return amount.subtract(this.couponAmount);
    }

    public boolean hasPercentOff() {
        return this.percentOff != null && !BigDecimal.ZERO.equals(this.percentOff);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Discount)) {
            return false;
        }
        Discount discount = (Discount)o;
        if (!this.id.equals(discount.id)) {
            return false;
        }
        return this.couponAmount.equals(discount.couponAmount);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.couponAmount.hashCode();
        return result;
    }

    Discount(Parcel in) {
        this.id = in.readString();
        this.name = in.readString();
        this.currencyId = in.readString();
        this.percentOff = ParcelableUtil.getOptionalBigDecimal(in);
        this.amountOff = ParcelableUtil.getOptionalBigDecimal(in);
        this.couponAmount = new BigDecimal(in.readString());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.name);
        dest.writeString(this.currencyId);
        ParcelableUtil.writeOptional(dest, this.percentOff);
        ParcelableUtil.writeOptional(dest, this.amountOff);
        dest.writeString(this.couponAmount.toString());
    }

    public static class Builder {
        @NonNull
        private final String id;
        @NonNull
        private final String currencyId;
        @NonNull
        private final BigDecimal couponAmount;
        @Nullable
        private String name;
        @Nullable
        private BigDecimal percentOff;
        @Nullable
        private BigDecimal amountOff;

        public Builder(@NonNull String id, @NonNull String currencyId, @NonNull BigDecimal couponAmount) {
            this.id = id;
            this.currencyId = currencyId;
            this.couponAmount = couponAmount;
            this.setPercentOff(BigDecimal.ZERO);
            this.setAmountOff(BigDecimal.ZERO);
        }

        public Builder setName(@NonNull String name) {
            this.name = name;
            return this;
        }

        public Builder setPercentOff(@NonNull BigDecimal percentOff) {
            this.percentOff = percentOff;
            return this;
        }

        public Builder setAmountOff(@NonNull BigDecimal amountOff) {
            this.amountOff = amountOff;
            return this;
        }

        public Discount build() {
            if (!CurrenciesUtil.isValidCurrency(this.currencyId)) {
                throw new IllegalStateException("invalid currency id");
            }
            return new Discount(this);
        }
    }
}

