/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mercadopago.android.px.internal.util.ParcelableUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;

public class Item
implements Serializable,
Parcelable {
    @Nullable
    private final String id;
    @NonNull
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final String pictureUrl;
    @Nullable
    private final String categoryId;
    @NonNull
    private final Integer quantity;
    @NonNull
    private final BigDecimal unitPrice;
    @Nullable
    private String currencyId;
    public static final Parcelable.Creator<Item> CREATOR = new Parcelable.Creator<Item>(){

        public Item createFromParcel(Parcel in) {
            return new Item(in);
        }

        public Item[] newArray(int size) {
            return new Item[size];
        }
    };

    Item(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.description = builder.description;
        this.pictureUrl = builder.pictureUrl;
        this.categoryId = builder.categoryId;
        this.quantity = builder.quantity;
        this.unitPrice = builder.unitPrice;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getPictureUrl() {
        return this.pictureUrl;
    }

    @Nullable
    public String getCategoryId() {
        return this.categoryId;
    }

    @NonNull
    public Integer getQuantity() {
        return this.quantity;
    }

    @Nullable
    public String getCurrencyId() {
        return this.currencyId;
    }

    @NonNull
    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public static BigDecimal getItemTotalAmount(@NonNull Item item) {
        return item.getUnitPrice().multiply(new BigDecimal(item.getQuantity()));
    }

    public boolean hasCardinality() {
        return this.quantity > 1;
    }

    public static boolean areItemsValid(@NonNull Collection<Item> items) {
        return !items.isEmpty() && Item.isEachItemValid(items) && BigDecimal.ZERO.compareTo(Item.getTotalAmountWith(items)) < 0;
    }

    private static boolean isEachItemValid(@NonNull Iterable<Item> items) {
        boolean areAllValid = true;
        for (Item item : items) {
            areAllValid = areAllValid && item.isItemValid();
        }
        return areAllValid;
    }

    private boolean isItemValid() {
        return this.getQuantity() > 0;
    }

    public static BigDecimal getTotalAmountWith(@NonNull Iterable<Item> items) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Item item : items) {
            totalAmount = totalAmount.add(Item.getItemTotalAmount(item));
        }
        return totalAmount;
    }

    Item(Parcel in) {
        this.title = in.readString();
        this.quantity = ParcelableUtil.getOptionalInteger(in);
        this.unitPrice = ParcelableUtil.getOptionalBigDecimal(in);
        this.id = in.readString();
        this.description = in.readString();
        this.categoryId = in.readString();
        this.pictureUrl = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.title);
        ParcelableUtil.writeOptional(dest, this.quantity);
        ParcelableUtil.writeOptional(dest, this.unitPrice);
        dest.writeString(this.id);
        dest.writeString(this.description);
        dest.writeString(this.categoryId);
        dest.writeString(this.pictureUrl);
    }

    public static final class Builder {
        @NonNull
        final String title;
        @NonNull
        final Integer quantity;
        @NonNull
        final BigDecimal unitPrice;
        @Nullable
        String id;
        @Nullable
        String description;
        @Nullable
        String categoryId;
        @Nullable
        String pictureUrl;

        public Builder(@NonNull String title, @NonNull Integer quantity, @NonNull BigDecimal unitPrice) {
            this.title = title;
            this.quantity = quantity;
            this.unitPrice = unitPrice;
        }

        public Builder setId(@NonNull String id) {
            this.id = id;
            return this;
        }

        public Builder setDescription(@NonNull String description) {
            this.description = description;
            return this;
        }

        public Builder setCategoryId(@NonNull String categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public Builder setPictureUrl(@NonNull String pictureUrl) {
            this.pictureUrl = pictureUrl;
            return this;
        }

        public Item build() {
            return new Item(this);
        }
    }
}

