/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.mercadopago.android.px.model.AccountMoney;
import com.mercadopago.android.px.model.Card;
import com.mercadopago.android.px.model.CustomSearchItem;
import com.mercadopago.android.px.model.DiscountConfigurationModel;
import com.mercadopago.android.px.model.ExpressMetadata;
import com.mercadopago.android.px.model.Issuer;
import com.mercadopago.android.px.model.OneTapMetadata;
import com.mercadopago.android.px.model.PaymentMethod;
import com.mercadopago.android.px.model.PaymentMethodSearchItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PaymentMethodSearch
implements Serializable {
    @Nullable
    private List<ExpressMetadata> express;
    private List<PaymentMethod> paymentMethods;
    private List<PaymentMethodSearchItem> groups;
    private List<Card> cards;
    @SerializedName(value="custom_options")
    private List<CustomSearchItem> customSearchItems;
    private String defaultAmountConfiguration;
    private Map<String, DiscountConfigurationModel> discountsConfigurations;
    @Deprecated
    @SerializedName(value="one_tap")
    private OneTapMetadata oneTapMetadata;

    @Deprecated
    public boolean hasOneTapMetadata() {
        return false;
    }

    @Deprecated
    public OneTapMetadata getOneTapMetadata() {
        return this.oneTapMetadata;
    }

    @Deprecated
    public void setCards(List<Card> cards) {
        this.cards = cards;
    }

    @Deprecated
    public void setPaymentMethods(List<PaymentMethod> paymentMethods) {
        this.paymentMethods = paymentMethods;
    }

    @Deprecated
    public void setAccountMoney(AccountMoney accountMoney) {
    }

    @Deprecated
    public boolean hasSavedCards() {
        return this.cards != null && !this.cards.isEmpty();
    }

    @Deprecated
    public void setCards(List<Card> cards, String lastFourDigitsText) {
        if (cards != null) {
            this.customSearchItems = new ArrayList<CustomSearchItem>();
            this.cards = new ArrayList<Card>();
            for (Card card : cards) {
                CustomSearchItem searchItem = new CustomSearchItem();
                searchItem.setDescription(lastFourDigitsText + " " + card.getLastFourDigits());
                searchItem.setType(card.getPaymentMethod().getPaymentTypeId());
                searchItem.setId(card.getId());
                searchItem.setPaymentMethodId(card.getPaymentMethod().getId());
                this.customSearchItems.add(searchItem);
                this.cards.add(card);
            }
        }
    }

    @Deprecated
    @Nullable
    public AccountMoney getAccountMoney() {
        return null;
    }

    @Deprecated
    public void setGroups(List<PaymentMethodSearchItem> groups) {
        this.groups = groups;
    }

    @NonNull
    public List<PaymentMethodSearchItem> getGroups() {
        return this.groups == null ? new ArrayList() : this.groups;
    }

    @NonNull
    public List<PaymentMethod> getPaymentMethods() {
        return this.paymentMethods == null ? new ArrayList() : this.paymentMethods;
    }

    public PaymentMethod getPaymentMethodBySearchItem(PaymentMethodSearchItem item) {
        PaymentMethod requiredPaymentMethod = null;
        if (this.paymentMethods != null && item != null && item.getId() != null) {
            for (PaymentMethod currentPaymentMethod : this.paymentMethods) {
                if (!this.itemMatchesPaymentMethod(item, currentPaymentMethod)) continue;
                requiredPaymentMethod = currentPaymentMethod;
                requiredPaymentMethod.setPaymentTypeId(this.getPaymentTypeIdFromItem(item, currentPaymentMethod));
            }
        }
        return requiredPaymentMethod;
    }

    private String getPaymentTypeIdFromItem(PaymentMethodSearchItem item, PaymentMethod paymentMethod) {
        String itemIdWithoutPaymentMethod = item.getId().replaceFirst(paymentMethod.getId(), "");
        String paymentType = itemIdWithoutPaymentMethod.isEmpty() ? paymentMethod.getPaymentTypeId() : itemIdWithoutPaymentMethod.substring(1);
        return paymentType;
    }

    private boolean itemMatchesPaymentMethod(PaymentMethodSearchItem item, PaymentMethod paymentMethod) {
        return item.getId().startsWith(paymentMethod.getId());
    }

    public PaymentMethodSearchItem getSearchItemByPaymentMethod(PaymentMethod selectedPaymentMethod) {
        PaymentMethodSearchItem requiredItem = null;
        if (selectedPaymentMethod != null) {
            requiredItem = this.searchItemMatchingPaymentMethod(selectedPaymentMethod);
        }
        return requiredItem;
    }

    private PaymentMethodSearchItem searchItemMatchingPaymentMethod(PaymentMethod paymentMethod) {
        return this.searchItemInList(this.groups, paymentMethod);
    }

    private PaymentMethodSearchItem searchItemInList(List<PaymentMethodSearchItem> list, PaymentMethod paymentMethod) {
        PaymentMethodSearchItem requiredItem = null;
        for (PaymentMethodSearchItem currentItem : list) {
            if (this.itemMatchesPaymentMethod(currentItem, paymentMethod) && currentItem.getId().equals(paymentMethod.getId())) {
                requiredItem = currentItem;
                break;
            }
            if (this.itemMatchesPaymentMethod(currentItem, paymentMethod)) {
                String potentialPaymentType = currentItem.getId().replaceFirst(paymentMethod.getId(), "");
                if (!potentialPaymentType.endsWith(paymentMethod.getPaymentTypeId())) continue;
                requiredItem = currentItem;
                break;
            }
            if (!currentItem.hasChildren() || (requiredItem = this.searchItemInList(currentItem.getChildren(), paymentMethod)) == null) continue;
            break;
        }
        return requiredItem;
    }

    @Nullable
    public PaymentMethod getPaymentMethodById(@Nullable String paymentMethodId) {
        for (PaymentMethod paymentMethod : this.getPaymentMethods()) {
            if (!paymentMethod.getId().equals(paymentMethodId)) continue;
            return paymentMethod;
        }
        return null;
    }

    @Nullable
    public Card getCardById(@NonNull String cardId) {
        for (CustomSearchItem customSearchItem : this.getCustomSearchItems()) {
            if (!customSearchItem.getId().equals(cardId)) continue;
            PaymentMethod paymentMethod = this.getPaymentMethodById(customSearchItem.getPaymentMethodId());
            Card card = new Card();
            card.setId(cardId);
            card.setSecurityCode(paymentMethod != null ? paymentMethod.getSecurityCode() : null);
            card.setPaymentMethod(paymentMethod);
            card.setFirstSixDigits(customSearchItem.getFirstSixDigits());
            card.setLastFourDigits(customSearchItem.getLastFourDigits());
            card.setIssuer(customSearchItem.getIssuer());
            return card;
        }
        return null;
    }

    @NonNull
    public List<CustomSearchItem> getCustomSearchItems() {
        return this.customSearchItems == null ? new ArrayList() : this.customSearchItems;
    }

    @Nullable
    public CustomSearchItem getCustomSearchItemByPaymentMethodId(@NonNull String paymentMethodId) {
        for (CustomSearchItem customSearchItem : this.customSearchItems) {
            if (!paymentMethodId.equals(customSearchItem.getPaymentMethodId())) continue;
            return customSearchItem;
        }
        return null;
    }

    @Deprecated
    @NonNull
    public List<Card> getCards() {
        return this.cards == null ? new ArrayList() : this.cards;
    }

    @Nullable
    public List<ExpressMetadata> getExpress() {
        return this.express;
    }

    public boolean hasExpressCheckoutMetadata() {
        return this.getExpress() != null && !this.getExpress().isEmpty();
    }

    public boolean hasCustomSearchItems() {
        return !this.getCustomSearchItems().isEmpty();
    }

    public boolean hasSearchItems() {
        return !this.getGroups().isEmpty();
    }

    @Nullable
    public Issuer getIssuer(@NonNull String cardId) {
        Card foundCard = this.getCardById(cardId);
        return foundCard == null ? null : foundCard.getIssuer();
    }

    @Nullable
    public String getLastFourDigits(@NonNull String cardId) {
        Card foundCard = this.getCardById(cardId);
        return foundCard == null ? null : foundCard.getLastFourDigits();
    }

    @NonNull
    public String getDefaultAmountConfiguration() {
        return this.defaultAmountConfiguration;
    }

    @NonNull
    public Map<String, DiscountConfigurationModel> getDiscountsConfigurations() {
        return this.discountsConfigurations == null ? new HashMap() : this.discountsConfigurations;
    }

    @NonNull
    public Set<String> getIdsWithSplitAllowed() {
        HashSet<String> cardsWithSplit = new HashSet<String>();
        for (CustomSearchItem customSearchItem : this.getCustomSearchItems()) {
            if (!customSearchItem.getAmountConfiguration(customSearchItem.getDefaultAmountConfiguration()).allowSplit()) continue;
            cardsWithSplit.add(customSearchItem.getId());
        }
        return cardsWithSplit;
    }
}

