/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mercadopago.android.px.model.Card;
import com.mercadopago.android.px.model.FeeDetail;
import com.mercadopago.android.px.model.IPayment;
import com.mercadopago.android.px.model.IPaymentDescriptor;
import com.mercadopago.android.px.model.IPaymentDescriptorHandler;
import com.mercadopago.android.px.model.Order;
import com.mercadopago.android.px.model.Payer;
import com.mercadopago.android.px.model.PaymentTypes;
import com.mercadopago.android.px.model.Refund;
import com.mercadopago.android.px.model.TransactionDetails;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class Payment
implements IPayment,
IPaymentDescriptor {
    private Boolean binaryMode;
    private String callForAuthorizeId;
    private Boolean captured;
    private Card card;
    private long collectorId;
    private BigDecimal couponAmount;
    private String currencyId;
    private Date dateApproved;
    private Date dateCreated;
    private Date dateLastUpdated;
    private String description;
    private Long differentialPricingId;
    private String externalReference;
    private List<FeeDetail> feeDetails;
    private Long id;
    private Integer installments;
    private String issuerId;
    private Boolean liveMode;
    private Map metadata;
    private Date moneyReleaseDate;
    private String notificationUrl;
    private String operationType;
    private Order order;
    private Payer payer;
    private String paymentMethodId;
    private String paymentTypeId;
    private List<Refund> refunds;
    private String statementDescriptor;
    private String status;
    private String statusDetail;
    private BigDecimal transactionAmount;
    private BigDecimal transactionAmountRefunded;
    private TransactionDetails transactionDetails;

    public Payment() {
    }

    public Payment(@NonNull String status, @NonNull String statusDetail) {
        this.status = status;
        this.statusDetail = statusDetail;
    }

    public Boolean getBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(Boolean binaryMode) {
        this.binaryMode = binaryMode;
    }

    public String getCallForAuthorizeId() {
        return this.callForAuthorizeId;
    }

    public void setCallForAuthorizeId(String callForAuthorizeId) {
        this.callForAuthorizeId = callForAuthorizeId;
    }

    public Boolean getCaptured() {
        return this.captured;
    }

    public void setCaptured(Boolean captured) {
        this.captured = captured;
    }

    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public Long getCollectorId() {
        return this.collectorId;
    }

    public void setCollectorId(Long collectorId) {
        this.collectorId = collectorId;
    }

    public BigDecimal getCouponAmount() {
        return this.couponAmount;
    }

    public void setCouponAmount(BigDecimal couponAmount) {
        this.couponAmount = couponAmount;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public Date getDateApproved() {
        return this.dateApproved;
    }

    public void setDateApproved(Date dateApproved) {
        this.dateApproved = dateApproved;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateLastUpdated() {
        return this.dateLastUpdated;
    }

    public void setDateLastUpdated(Date dateLastUpdated) {
        this.dateLastUpdated = dateLastUpdated;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getDifferentialPricingId() {
        return this.differentialPricingId;
    }

    public void setDifferentialPricingId(Long differentialPricingId) {
        this.differentialPricingId = differentialPricingId;
    }

    public String getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(String externalReference) {
        this.externalReference = externalReference;
    }

    public List<FeeDetail> getFeeDetails() {
        return this.feeDetails;
    }

    public void setFeeDetails(List<FeeDetail> feeDetails) {
        this.feeDetails = feeDetails;
    }

    @Override
    @Nullable
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getInstallments() {
        return this.installments;
    }

    public void setInstallments(Integer installments) {
        this.installments = installments;
    }

    public String getIssuerId() {
        return this.issuerId;
    }

    public void setIssuerId(String issuerId) {
        this.issuerId = issuerId;
    }

    public Boolean getLiveMode() {
        return this.liveMode;
    }

    public void setLiveMode(Boolean liveMode) {
        this.liveMode = liveMode;
    }

    public Map getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map metadata) {
        this.metadata = metadata;
    }

    public Date getMoneyReleaseDate() {
        return this.moneyReleaseDate;
    }

    public void setMoneyReleaseDate(Date moneyReleaseDate) {
        this.moneyReleaseDate = moneyReleaseDate;
    }

    public String getNotificationUrl() {
        return this.notificationUrl;
    }

    public void setNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    @Override
    @NonNull
    public String getPaymentTypeId() {
        return this.paymentTypeId;
    }

    @Override
    @NonNull
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    @Override
    public void process(@NonNull IPaymentDescriptorHandler handler) {
        handler.visit(this);
    }

    @Deprecated
    public void setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    @Deprecated
    public void setPaymentTypeId(String paymentTypeId) {
        this.paymentTypeId = paymentTypeId;
    }

    public List<Refund> getRefunds() {
        return this.refunds;
    }

    @Deprecated
    public void setRefunds(List<Refund> refunds) {
        this.refunds = refunds;
    }

    @Deprecated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Deprecated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Deprecated
    public void setStatus(String status) {
        this.status = status;
    }

    @Deprecated
    public void setStatusDetail(String statusDetail) {
        this.statusDetail = statusDetail;
    }

    public BigDecimal getTransactionAmount() {
        return this.transactionAmount;
    }

    @Deprecated
    public void setTransactionAmount(BigDecimal transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public BigDecimal getTransactionAmountRefunded() {
        return this.transactionAmountRefunded;
    }

    @Deprecated
    public void setTransactionAmountRefunded(BigDecimal transactionAmountRefunded) {
        this.transactionAmountRefunded = transactionAmountRefunded;
    }

    public TransactionDetails getTransactionDetails() {
        return this.transactionDetails;
    }

    @Deprecated
    public void setTransactionDetails(TransactionDetails transactionDetails) {
        this.transactionDetails = transactionDetails;
    }

    public Boolean isCardPaymentType(String paymentTypeId) {
        return paymentTypeId.equals(PaymentTypes.CREDIT_CARD) || paymentTypeId.equals(PaymentTypes.DEBIT_CARD) || paymentTypeId.equals(PaymentTypes.PREPAID_CARD);
    }

    public static boolean isPendingStatus(String status, String statusDetail) {
        return "pending".equals(status) && "pending_waiting_payment".equals(statusDetail);
    }

    public String toString() {
        return "Payment{binaryMode=" + this.binaryMode + ", callForAuthorizeId='" + this.callForAuthorizeId + '\'' + ", captured=" + this.captured + ", card=" + this.card + ", collectorId=" + this.collectorId + ", couponAmount=" + this.couponAmount + ", currencyId='" + this.currencyId + '\'' + ", dateApproved=" + this.dateApproved + ", dateCreated=" + this.dateCreated + ", dateLastUpdated=" + this.dateLastUpdated + ", description='" + this.description + '\'' + ", differentialPricingId=" + this.differentialPricingId + ", externalReference='" + this.externalReference + '\'' + ", feeDetails=" + this.feeDetails + ", id=" + this.id + ", installments=" + this.installments + ", issuerId='" + this.issuerId + '\'' + ", liveMode=" + this.liveMode + ", metadata=" + this.metadata + ", moneyReleaseDate=" + this.moneyReleaseDate + ", notificationUrl='" + this.notificationUrl + '\'' + ", operationType='" + this.operationType + '\'' + ", order=" + this.order + ", payer=" + this.payer + ", paymentMethodId='" + this.paymentMethodId + '\'' + ", paymentTypeId='" + this.paymentTypeId + '\'' + ", refunds=" + this.refunds + ", statementDescriptor='" + this.statementDescriptor + '\'' + ", status='" + this.status + '\'' + ", statusDetail='" + this.statusDetail + '\'' + ", transactionAmount=" + this.transactionAmount + ", transactionAmountRefunded=" + this.transactionAmountRefunded + ", transactionDetails=" + this.transactionDetails + '}';
    }

    @Override
    @Nullable
    public String getStatementDescription() {
        return this.statementDescriptor;
    }

    @Override
    @NonNull
    public String getPaymentStatus() {
        return this.status;
    }

    @Override
    @NonNull
    public String getPaymentStatusDetail() {
        return this.statusDetail;
    }

    public static class StatusDetail {
        @Deprecated
        public static final String STATUS_DETAIL_APPROVED_PLUGIN_PM = "approved_plugin_pm";
        @Deprecated
        public static final String STATUS_DETAIL_CC_REJECTED_PLUGIN_PM = "cc_rejected_plugin_pm";
        public static final String STATUS_DETAIL_ACCREDITED = "accredited";
        public static final String STATUS_DETAIL_CC_REJECTED_CALL_FOR_AUTHORIZE = "cc_rejected_call_for_authorize";
        public static final String STATUS_DETAIL_PENDING_CONTINGENCY = "pending_contingency";
        public static final String STATUS_DETAIL_PENDING_REVIEW_MANUAL = "pending_review_manual";
        public static final String STATUS_DETAIL_PENDING_WAITING_PAYMENT = "pending_waiting_payment";
        public static final String STATUS_DETAIL_CC_REJECTED_OTHER_REASON = "cc_rejected_other_reason";
        public static final String STATUS_DETAIL_INVALID_ESC = "invalid_esc";
        public static final String STATUS_DETAIL_CC_REJECTED_CARD_DISABLED = "cc_rejected_card_disabled";
        public static final String STATUS_DETAIL_CC_REJECTED_INSUFFICIENT_AMOUNT = "cc_rejected_insufficient_amount";
        public static final String STATUS_DETAIL_CC_REJECTED_BAD_FILLED_OTHER = "cc_rejected_bad_filled_other";
        public static final String STATUS_DETAIL_CC_REJECTED_BAD_FILLED_CARD_NUMBER = "cc_rejected_bad_filled_card_number";
        public static final String STATUS_DETAIL_CC_REJECTED_BAD_FILLED_SECURITY_CODE = "cc_rejected_bad_filled_security_code";
        public static final String STATUS_DETAIL_CC_REJECTED_BAD_FILLED_DATE = "cc_rejected_bad_filled_date";
        public static final String STATUS_DETAIL_CC_REJECTED_DUPLICATED_PAYMENT = "cc_rejected_duplicated_payment";
        public static final String STATUS_DETAIL_CC_REJECTED_HIGH_RISK = "cc_rejected_high_risk";
        public static final String STATUS_DETAIL_REJECTED_HIGH_RISK = "rejected_high_risk";
        public static final String STATUS_DETAIL_CC_REJECTED_MAX_ATTEMPTS = "cc_rejected_max_attempts";
        public static final String STATUS_DETAIL_REJECTED_REJECTED_BY_BANK = "rejected_by_bank";
        public static final String STATUS_DETAIL_REJECTED_REJECTED_INSUFFICIENT_DATA = "rejected_insufficient_data";
        public static final String STATUS_DETAIL_REJECTED_BY_REGULATIONS = "rejected_by_regulations";
        public static final String STATUS_DETAIL_CC_REJECTED_FRAUD = "cc_rejected_fraud";
        public static final String STATUS_DETAIL_CC_REJECTED_BLACKLIST = "cc_rejected_blacklist";

        private static Collection<Field> getAll() {
            Field[] declaredFields = StatusDetail.class.getDeclaredFields();
            ArrayList<Field> staticFields = new ArrayList<Field>();
            for (Field field : declaredFields) {
                if (!Modifier.isStatic(field.getModifiers())) continue;
                staticFields.add(field);
            }
            return staticFields;
        }

        public static Collection<String> getAllStaticFields() {
            ArrayList<String> statusList = new ArrayList<String>();
            for (Field status : StatusDetail.getAll()) {
                statusList.add(status.getName());
            }
            return statusList;
        }

        public static boolean isKnownStatusDetail(String statusDetail) {
            boolean knownError = false;
            for (String status : StatusDetail.getAllStaticFields()) {
                if (!status.toLowerCase().contains(statusDetail.toLowerCase())) continue;
                knownError = true;
                break;
            }
            return knownError;
        }

        public static boolean isPaymentStatusRecoverable(String statusDetail) {
            return STATUS_DETAIL_CC_REJECTED_BAD_FILLED_OTHER.equals(statusDetail) || STATUS_DETAIL_CC_REJECTED_BAD_FILLED_CARD_NUMBER.equals(statusDetail) || STATUS_DETAIL_CC_REJECTED_BAD_FILLED_SECURITY_CODE.equals(statusDetail) || STATUS_DETAIL_CC_REJECTED_BAD_FILLED_DATE.equals(statusDetail) || STATUS_DETAIL_CC_REJECTED_CALL_FOR_AUTHORIZE.equals(statusDetail) || STATUS_DETAIL_INVALID_ESC.equals(statusDetail) || STATUS_DETAIL_CC_REJECTED_CARD_DISABLED.equals(statusDetail);
        }

        public static boolean isStatusDetailRecoverable(String statusDetail) {
            return STATUS_DETAIL_CC_REJECTED_CALL_FOR_AUTHORIZE.equals(statusDetail) || STATUS_DETAIL_INVALID_ESC.equals(statusDetail) || STATUS_DETAIL_CC_REJECTED_CARD_DISABLED.equals(statusDetail);
        }

        public static boolean isRecoverablePaymentStatus(String paymentStatus, String paymentStatusDetail) {
            return "rejected".equals(paymentStatus) && StatusDetail.isPaymentStatusRecoverable(paymentStatusDetail);
        }

        public static boolean isBadFilled(String statusDetail) {
            return STATUS_DETAIL_CC_REJECTED_BAD_FILLED_DATE.equals(statusDetail) || STATUS_DETAIL_CC_REJECTED_BAD_FILLED_SECURITY_CODE.equals(statusDetail) || STATUS_DETAIL_CC_REJECTED_BAD_FILLED_OTHER.equals(statusDetail) || STATUS_DETAIL_CC_REJECTED_BAD_FILLED_CARD_NUMBER.equals(statusDetail);
        }

        public static boolean isPendingWithDetail(@Nullable String statusDetail) {
            return STATUS_DETAIL_PENDING_CONTINGENCY.equals(statusDetail) || STATUS_DETAIL_PENDING_REVIEW_MANUAL.equals(statusDetail);
        }

        public static boolean isRejectedWithDetail(@NonNull String statusDetail) {
            switch (statusDetail) {
                case "cc_rejected_insufficient_amount": 
                case "rejected_by_regulations": 
                case "cc_rejected_card_disabled": 
                case "cc_rejected_call_for_authorize": 
                case "rejected_high_risk": 
                case "cc_rejected_max_attempts": 
                case "cc_rejected_duplicated_payment": 
                case "rejected_insufficient_data": 
                case "rejected_by_bank": 
                case "cc_rejected_other_reason": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class StatusCodes {
        public static final String STATUS_APPROVED = "approved";
        public static final String STATUS_IN_PROCESS = "in_process";
        public static final String STATUS_REJECTED = "rejected";
        public static final String STATUS_PENDING = "pending";
    }
}

