/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mercadopago.android.px.model.IPayment;
import com.mercadopago.android.px.model.Payment;

public class GenericPayment
implements IPayment,
Parcelable {
    public final Long id;
    public final String status;
    public final String statusDetail;
    @Nullable
    public final String statementDescription;
    public static final Parcelable.Creator<GenericPayment> CREATOR = new Parcelable.Creator<GenericPayment>(){

        public GenericPayment createFromParcel(Parcel in) {
            return new GenericPayment(in);
        }

        public GenericPayment[] newArray(int size) {
            return new GenericPayment[size];
        }
    };

    public GenericPayment(Long paymentId, @NonNull String status, @NonNull String statusDetail) {
        this.id = paymentId;
        this.status = status;
        this.statusDetail = this.processStatusDetail(status, statusDetail);
        this.statementDescription = null;
    }

    private String processStatusDetail(@NonNull String status, @NonNull String statusDetail) {
        if ("approved".equals(status)) {
            return "approved_plugin_pm";
        }
        if ("rejected".equals(status)) {
            if (Payment.StatusDetail.isKnownErrorDetail(statusDetail)) {
                return statusDetail;
            }
            return "cc_rejected_plugin_pm";
        }
        return statusDetail;
    }

    @Override
    @Nullable
    public Long getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getStatementDescription() {
        return this.statementDescription;
    }

    @Override
    @NonNull
    public String getPaymentStatus() {
        return this.status;
    }

    @Override
    @NonNull
    public String getPaymentStatusDetail() {
        return this.statusDetail;
    }

    public static GenericPayment from(IPayment payment) {
        return new GenericPayment(payment.getId(), payment.getPaymentStatus(), payment.getPaymentStatusDetail(), payment.getStatementDescription());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.id == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeLong(this.id.longValue());
        }
        dest.writeString(this.status);
        dest.writeString(this.statusDetail);
        dest.writeString(this.statementDescription);
    }

    protected GenericPayment(Parcel in) {
        this.id = in.readByte() == 0 ? null : Long.valueOf(in.readLong());
        this.status = in.readString();
        this.statusDetail = in.readString();
        this.statementDescription = in.readString();
    }

    public GenericPayment(Long paymentId, @NonNull String status, @NonNull String statusDetail, @NonNull String statementDescription) {
        this.id = paymentId;
        this.status = status;
        this.statusDetail = this.processStatusDetail(status, statusDetail);
        this.statementDescription = statementDescription;
    }
}

