/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.preferences;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.google.gson.annotations.SerializedName;
import com.mercadopago.android.px.internal.util.TextUtil;
import com.mercadopago.android.px.model.DifferentialPricing;
import com.mercadopago.android.px.model.Item;
import com.mercadopago.android.px.model.Payer;
import com.mercadopago.android.px.model.Site;
import com.mercadopago.android.px.model.Sites;
import com.mercadopago.android.px.model.exceptions.CheckoutPreferenceException;
import com.mercadopago.android.px.preferences.PaymentPreference;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CheckoutPreference
implements Serializable {
    @Nullable
    private String id;
    @NonNull
    private final String siteId;
    @NonNull
    private final List<Item> items;
    @NonNull
    private final Payer payer;
    @SerializedName(value="differential_pricing")
    @Nullable
    private final DifferentialPricing differentialPricing;
    @SerializedName(value="payment_methods")
    @Nullable
    private final PaymentPreference paymentPreference;
    @Nullable
    private final Date expirationDateTo;
    @Nullable
    private final Date expirationDateFrom;
    @Nullable
    private final BigDecimal marketplaceFee;
    @Nullable
    private final BigDecimal shippingCost;
    @Nullable
    private final String operationType;
    @Nullable
    private final BigDecimal conceptAmount;
    @Nullable
    private final String conceptId;
    @SerializedName(value="binary_mode")
    private boolean isBinaryMode = false;

    CheckoutPreference(Builder builder) {
        this.items = builder.items;
        this.expirationDateFrom = builder.expirationDateFrom;
        this.expirationDateTo = builder.expirationDateTo;
        this.siteId = builder.site.getId();
        this.marketplaceFee = builder.marketplaceFee;
        this.shippingCost = builder.shippingCost;
        this.operationType = builder.operationType;
        this.differentialPricing = builder.differentialPricing;
        this.conceptAmount = builder.conceptAmount;
        this.conceptId = builder.conceptId;
        this.payer = new Payer();
        this.payer.setEmail(builder.payerEmail);
        this.isBinaryMode = builder.isBinaryMode;
        this.paymentPreference = new PaymentPreference();
        this.paymentPreference.setExcludedPaymentTypeIds(builder.excludedPaymentTypes);
        this.paymentPreference.setExcludedPaymentMethodIds(builder.excludedPaymentMethods);
        this.paymentPreference.setMaxAcceptedInstallments(builder.maxInstallments);
        this.paymentPreference.setDefaultInstallments(builder.defaultInstallments);
    }

    public void validate() throws CheckoutPreferenceException {
        if (!Item.areItemsValid(this.items)) {
            throw new CheckoutPreferenceException(0);
        }
        if (TextUtil.isEmpty(this.payer.getEmail())) {
            throw new CheckoutPreferenceException(6);
        }
        if (this.isExpired().booleanValue()) {
            throw new CheckoutPreferenceException(1);
        }
        if (!this.isActive().booleanValue()) {
            throw new CheckoutPreferenceException(2);
        }
        if (!this.validInstallmentsPreference()) {
            throw new CheckoutPreferenceException(3);
        }
        if (!this.validPaymentTypeExclusion()) {
            throw new CheckoutPreferenceException(4);
        }
    }

    boolean validPaymentTypeExclusion() {
        return this.getPaymentPreference().excludedPaymentTypesValid();
    }

    boolean validInstallmentsPreference() {
        return this.getPaymentPreference().installmentPreferencesValid();
    }

    Boolean isExpired() {
        Date date = new Date();
        return this.expirationDateTo != null && date.after(this.expirationDateTo);
    }

    Boolean isActive() {
        Date date = new Date();
        return this.expirationDateFrom == null || date.after(this.expirationDateFrom);
    }

    @Nullable
    public String getOperationType() {
        return this.operationType;
    }

    @Nullable
    public BigDecimal getMarketplaceFee() {
        return this.marketplaceFee;
    }

    @Nullable
    public BigDecimal getShippingCost() {
        return this.shippingCost;
    }

    @Nullable
    public DifferentialPricing getDifferentialPricing() {
        return this.differentialPricing;
    }

    @Nullable
    public BigDecimal getConceptAmount() {
        return this.conceptAmount;
    }

    @Nullable
    public String getConceptId() {
        return this.conceptId;
    }

    @NonNull
    public BigDecimal getTotalAmount() {
        return Item.getTotalAmountWith(this.items);
    }

    @NonNull
    public Site getSite() {
        return Sites.getById(this.siteId);
    }

    @Size(min=1L)
    @NonNull
    public List<Item> getItems() {
        return this.items;
    }

    @NonNull
    public Payer getPayer() {
        return this.payer;
    }

    @Nullable
    public Date getExpirationDateFrom() {
        return this.expirationDateFrom;
    }

    @Nullable
    public Date getExpirationDateTo() {
        return this.expirationDateTo;
    }

    @Nullable
    public String getDefaultPaymentMethodId() {
        return this.getPaymentPreference().getDefaultPaymentMethodId();
    }

    @Nullable
    public Integer getDefaultInstallments() {
        return this.getPaymentPreference().getDefaultInstallments();
    }

    @Nullable
    public Integer getMaxInstallments() {
        return this.getPaymentPreference().getMaxInstallments();
    }

    @NonNull
    public List<String> getExcludedPaymentTypes() {
        return this.getPaymentPreference().getExcludedPaymentTypes();
    }

    @NonNull
    public List<String> getExcludedPaymentMethods() {
        return this.getPaymentPreference().getExcludedPaymentMethodIds();
    }

    @NonNull
    public PaymentPreference getPaymentPreference() {
        return this.paymentPreference == null ? new PaymentPreference() : this.paymentPreference;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public boolean isBinaryMode() {
        return this.isBinaryMode;
    }

    public static class Builder {
        final List<Item> items;
        final Site site;
        final String payerEmail;
        final List<String> excludedPaymentMethods;
        final List<String> excludedPaymentTypes;
        Integer maxInstallments;
        Integer defaultInstallments;
        Date expirationDateTo;
        Date expirationDateFrom;
        BigDecimal marketplaceFee;
        BigDecimal shippingCost;
        String operationType;
        @Nullable
        DifferentialPricing differentialPricing;
        BigDecimal conceptAmount;
        String conceptId;
        boolean isBinaryMode = false;

        public Builder(@NonNull Site site, @NonNull String payerEmail, @Size(min=1L) @NonNull List<Item> items) {
            this.items = items;
            this.payerEmail = payerEmail;
            this.site = site;
            this.excludedPaymentMethods = new ArrayList<String>();
            this.excludedPaymentTypes = new ArrayList<String>();
        }

        public Builder addExcludedPaymentMethod(@NonNull String paymentMethodId) {
            this.excludedPaymentMethods.add(paymentMethodId);
            return this;
        }

        public Builder addExcludedPaymentMethods(@NonNull Collection<String> paymentMethodIds) {
            this.excludedPaymentMethods.addAll(paymentMethodIds);
            return this;
        }

        public Builder addExcludedPaymentType(@NonNull String paymentTypeId) {
            this.excludedPaymentTypes.add(paymentTypeId);
            return this;
        }

        public Builder addExcludedPaymentTypes(@NonNull Collection<String> paymentTypeIds) {
            this.excludedPaymentTypes.addAll(paymentTypeIds);
            return this;
        }

        public Builder setBinaryMode(boolean isBinaryMode) {
            this.isBinaryMode = isBinaryMode;
            return this;
        }

        public Builder setMaxInstallments(@Nullable Integer maxInstallments) {
            this.maxInstallments = maxInstallments;
            return this;
        }

        public Builder setDefaultInstallments(@Nullable Integer defaultInstallments) {
            this.defaultInstallments = defaultInstallments;
            return this;
        }

        public Builder setExpirationDate(@Nullable Date date) {
            this.expirationDateTo = date;
            return this;
        }

        public Builder setActiveFrom(@Nullable Date date) {
            this.expirationDateFrom = date;
            return this;
        }

        public Builder setDifferentialPricing(@Nullable DifferentialPricing differentialPricing) {
            this.differentialPricing = differentialPricing;
            return this;
        }

        public Builder setMarketplaceFee(BigDecimal marketplaceFee) {
            this.marketplaceFee = marketplaceFee;
            return this;
        }

        public Builder setShippingCost(BigDecimal shippingCost) {
            this.shippingCost = shippingCost;
            return this;
        }

        public Builder setOperationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder setConceptAmount(BigDecimal conceptAmount) {
            this.conceptAmount = conceptAmount;
            return this;
        }

        public Builder setConceptId(String conceptId) {
            this.conceptId = conceptId;
            return this;
        }

        public CheckoutPreference build() {
            return new CheckoutPreference(this);
        }
    }
}

