/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.android.px.model;

import android.content.Context;
import android.text.TextUtils;
import com.mercadopago.android.px.model.Cardholder;
import com.mercadopago.android.px.model.Device;
import com.mercadopago.android.px.model.Identification;
import com.mercadopago.android.px.model.IdentificationType;
import com.mercadopago.android.px.model.PaymentMethod;
import com.mercadopago.android.px.model.Setting;
import com.mercadopago.android.px.model.exceptions.CardTokenException;
import java.util.Calendar;
import java.util.Locale;

public class CardToken {
    public static final int MIN_LENGTH_NUMBER = 10;
    public static final int MAX_LENGTH_NUMBER = 19;
    private static final Calendar now = Calendar.getInstance();
    private Cardholder cardholder;
    private String cardNumber;
    private Device device;
    private Integer expirationMonth;
    private Integer expirationYear;
    private String securityCode;

    public CardToken(String cardNumber, Integer expirationMonth, Integer expirationYear, String securityCode, String cardholderName, String identificationType, String identificationNumber) {
        this.cardNumber = this.normalizeCardNumber(cardNumber);
        this.expirationMonth = expirationMonth;
        this.expirationYear = CardToken.normalizeYear(expirationYear);
        this.securityCode = securityCode;
        this.cardholder = new Cardholder();
        this.cardholder.setName(cardholderName);
        Identification identification = new Identification();
        identification.setNumber(identificationNumber);
        identification.setType(identificationType);
        this.cardholder.setIdentification(identification);
    }

    public static boolean validateSecurityCode(String securityCode) {
        return !TextUtils.isEmpty((CharSequence)securityCode) && securityCode.length() >= 3 && securityCode.length() <= 4;
    }

    public static void validateSecurityCode(String securityCode, PaymentMethod paymentMethod, String bin) throws CardTokenException {
        if (paymentMethod != null) {
            Setting setting = Setting.getSettingByBin(paymentMethod.getSettings(), bin);
            if (setting != null) {
                int cvvLength = setting.getSecurityCode().getLength();
                if (securityCode == null || cvvLength != 0 && securityCode.trim().length() != cvvLength) {
                    throw new CardTokenException(5, String.valueOf(cvvLength));
                }
            } else {
                throw new CardTokenException(6);
            }
        }
    }

    public static boolean validateExpiryDate(Integer month, Integer year) {
        if (!CardToken.validateExpMonth(month)) {
            return false;
        }
        if (!CardToken.validateExpYear(year)) {
            return false;
        }
        return !CardToken.hasMonthPassed(month, year);
    }

    public static boolean validateExpMonth(Integer month) {
        return month != null && month >= 1 && month <= 12;
    }

    public static boolean validateExpYear(Integer year) {
        return year != null && !CardToken.hasYearPassed(year);
    }

    public static boolean checkLuhn(String cardNumber) {
        int sum = 0;
        boolean alternate = false;
        if (cardNumber == null || cardNumber.length() == 0) {
            return false;
        }
        for (int i = cardNumber.length() - 1; i >= 0; --i) {
            int n = Integer.parseInt(cardNumber.substring(i, i + 1));
            if (alternate && (n *= 2) > 9) {
                n = n % 10 + 1;
            }
            sum += n;
            alternate = !alternate;
        }
        return sum % 10 == 0;
    }

    private static boolean hasYearPassed(int year) {
        int normalized = CardToken.normalizeYear(year);
        return normalized < now.get(1);
    }

    private static boolean hasMonthPassed(int month, int year) {
        return CardToken.hasYearPassed(year) || CardToken.normalizeYear(year).intValue() == now.get(1) && month < now.get(2) + 1;
    }

    private static Integer normalizeYear(Integer year) {
        Integer normalizedYear = year;
        if (year != null && year < 100 && year >= 0) {
            String currentYear = String.valueOf(now.get(1));
            String prefix = currentYear.substring(0, currentYear.length() - 2);
            normalizedYear = Integer.parseInt(String.format(Locale.US, "%s%02d", prefix, year));
        }
        return normalizedYear;
    }

    public Cardholder getCardholder() {
        return this.cardholder;
    }

    public void setCardholder(Cardholder cardholder) {
        this.cardholder = cardholder;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Context context) {
        this.device = new Device(context);
    }

    public Integer getExpirationMonth() {
        return this.expirationMonth;
    }

    public void setExpirationMonth(Integer expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    public Integer getExpirationYear() {
        return this.expirationYear;
    }

    public void setExpirationYear(Integer expirationYear) {
        this.expirationYear = CardToken.normalizeYear(expirationYear);
    }

    public String getSecurityCode() {
        return this.securityCode;
    }

    public void setSecurityCode(String securityCode) {
        this.securityCode = securityCode;
    }

    public boolean validate(boolean includeSecurityCode) {
        boolean result;
        boolean bl = result = this.validateCardNumber() && this.validateExpiryDate() && this.validateIdentification() && this.validateCardholderName();
        if (includeSecurityCode) {
            result = result && this.validateSecurityCode();
        }
        return result;
    }

    public boolean validateCardNumber() {
        return !TextUtils.isEmpty((CharSequence)this.cardNumber) && this.cardNumber.length() > 10 && this.cardNumber.length() < 19;
    }

    public void validateCardNumber(PaymentMethod paymentMethod) throws CardTokenException {
        if (this.cardNumber == null || this.cardNumber.isEmpty()) {
            throw new CardTokenException(1);
        }
        Setting setting = Setting.getSettingByBin(paymentMethod.getSettings(), this.cardNumber.length() >= 6 ? this.cardNumber.substring(0, 6) : "");
        if (setting == null) {
            throw new CardTokenException(2);
        }
        int cardLength = setting.getCardNumber().getLength();
        if (this.cardNumber.trim().length() != cardLength) {
            throw new CardTokenException(3, String.valueOf(cardLength));
        }
        String luhnAlgorithm = setting.getCardNumber().getValidation();
        if ("standard".equals(luhnAlgorithm) && !CardToken.checkLuhn(this.cardNumber)) {
            throw new CardTokenException(4);
        }
    }

    public boolean validateSecurityCode() {
        return CardToken.validateSecurityCode(this.securityCode);
    }

    public void validateSecurityCode(PaymentMethod paymentMethod) throws CardTokenException {
        CardToken.validateSecurityCode(this.securityCode, paymentMethod, (this.cardNumber != null ? this.cardNumber.length() : 0) >= 6 ? this.cardNumber.substring(0, 6) : "");
    }

    public boolean validateIdentificationNumber(IdentificationType identificationType) {
        if (identificationType != null) {
            if (this.cardholder != null && this.cardholder.getIdentification() != null && this.cardholder.getIdentification().getNumber() != null) {
                int len = this.cardholder.getIdentification().getNumber().length();
                Integer min = identificationType.getMinLength();
                Integer max = identificationType.getMaxLength();
                if (min != null && max != null) {
                    return len <= max && len >= min;
                }
                return this.validateIdentificationNumber();
            }
            return false;
        }
        return this.validateIdentificationNumber();
    }

    public boolean validateExpiryDate() {
        return CardToken.validateExpiryDate(this.expirationMonth, this.expirationYear);
    }

    public boolean validateIdentification() {
        return this.validateIdentificationType() && this.validateIdentificationNumber();
    }

    public boolean validateIdentificationType() {
        return this.cardholder != null && this.cardholder.getIdentification() != null && !TextUtils.isEmpty((CharSequence)this.cardholder.getIdentification().getType());
    }

    public boolean validateIdentificationNumber() {
        return this.cardholder != null && this.cardholder.getIdentification() != null && this.validateIdentificationType() && !TextUtils.isEmpty((CharSequence)this.cardholder.getIdentification().getNumber());
    }

    public boolean validateCardholderName() {
        return this.cardholder != null && this.cardholder.getName() != null && !this.cardholder.getName().isEmpty();
    }

    private String normalizeCardNumber(String number) {
        return number.trim().replaceAll("\\s+|-", "");
    }
}

