/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.util;

import com.mdsol.mauth.exceptions.MAuthKeyException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class MAuthKeysHelper {
    private static final JcaPEMKeyConverter KEY_CONVERTER = new JcaPEMKeyConverter().setProvider("BC");

    public static PublicKey getPublicKeyFromString(String string) {
        PublicKey publicKey;
        try (PEMParser pEMParser = new PEMParser((Reader)new StringReader(string));){
            publicKey = KEY_CONVERTER.getPublicKey((SubjectPublicKeyInfo)pEMParser.readObject());
        }
        catch (IOException iOException) {
            throw new MAuthKeyException("Unable to process public key string", iOException);
        }
        return publicKey;
    }

    public static PrivateKey getPrivateKeyFromString(String string) {
        PrivateKey privateKey;
        block8: {
            try (PEMParser pEMParser = new PEMParser((Reader)new StringReader(string));){
                PEMKeyPair pEMKeyPair = (PEMKeyPair)pEMParser.readObject();
                if (pEMKeyPair != null) {
                    privateKey = KEY_CONVERTER.getPrivateKey(pEMKeyPair.getPrivateKeyInfo());
                    break block8;
                }
                throw new MAuthKeyException("Unable to process private key string");
            }
            catch (IOException iOException) {
                throw new MAuthKeyException("Unable to process private key string", iOException);
            }
        }
        return privateKey;
    }
}

