/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl.handlers;

import com.marklogic.http.HttpChannel;
import com.marklogic.io.IOHelper;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.ContentPermission;
import com.marklogic.xcc.DocumentFormat;
import com.marklogic.xcc.DocumentRepairLevel;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.ContentInsertException;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.RequestServerException;
import com.marklogic.xcc.exceptions.RetryableQueryException;
import com.marklogic.xcc.impl.RequestImpl;
import com.marklogic.xcc.impl.SessionImpl;
import com.marklogic.xcc.impl.handlers.AbstractRequestController;
import com.marklogic.xcc.impl.handlers.BadMethodHandler;
import com.marklogic.xcc.impl.handlers.EntityResolveHandler;
import com.marklogic.xcc.impl.handlers.EntityTooLargeHandler;
import com.marklogic.xcc.impl.handlers.GoodInsertResponseHandler;
import com.marklogic.xcc.impl.handlers.NotFoundCodeHandler;
import com.marklogic.xcc.impl.handlers.PDCloudForbiddenHandler;
import com.marklogic.xcc.impl.handlers.PDCloudGoneHandler;
import com.marklogic.xcc.impl.handlers.ResponseHandler;
import com.marklogic.xcc.impl.handlers.ServerExceptionHandler;
import com.marklogic.xcc.impl.handlers.ServiceUnavailableHandler;
import com.marklogic.xcc.impl.handlers.UnSupportedTypeHandler;
import com.marklogic.xcc.impl.handlers.UnauthorizedHandler;
import com.marklogic.xcc.impl.handlers.UnrecognizedCodeHandler;
import com.marklogic.xcc.spi.ConnectionProvider;
import com.marklogic.xcc.spi.ServerConnection;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContentInsertController
extends AbstractRequestController {
    public static final int HTTP_TEMPORARY_REDIRECT = 307;
    static final int DEFAULT_BUFFER_SIZE = 131072;
    static final int MAX_BUFFER_SIZE = 0xC00000;
    private static final int COMMIT = 1;
    private static final int NO_COMMIT = 2;
    private static final Map<Integer, ResponseHandler> handlers = new HashMap<Integer, ResponseHandler>(8);
    private final Content[] contents;
    private final LinkedList<Content> processedContent = new LinkedList();
    private ByteBuffer dataBuffer = null;
    private boolean collectErrors;
    private List<RequestException> errorList;

    public ContentInsertController(Content[] contents, Session.TransactionMode txnMode) {
        this(contents, txnMode, false, null);
    }

    public ContentInsertController(Content[] contents, Session.TransactionMode txnMode, boolean ignoreErrors, String basePath) {
        super(handlers, "/", basePath);
        this.contents = (Content[])contents.clone();
        this.collectErrors = ignoreErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSequence serverDialog(ServerConnection connection, Request request, RequestOptions options, Logger logger) throws RequestException, IOException {
        this.assertRestartable(this.processedContent, request);
        LinkedList<ContentDecorator> remaining = this.toLinkedList(this.contents);
        logger.fine("beginning content insert dialog, " + remaining.size() + " documents queued");
        ConnectionProvider provider = connection.provider();
        HttpChannel http = new HttpChannel(connection.channel(), "PUT", this.httpPath, 0, options.getTimeoutMillis(), logger);
        boolean first = true;
        boolean connectionReplaced = false;
        while (remaining.size() > 0) {
            ContentDecorator entityContent;
            ContentDecorator content;
            block23: {
                boolean commit;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("" + this.processedContent.size() + " items sent, " + remaining.size() + " remaining");
                }
                content = remaining.remove(0);
                boolean bl = commit = remaining.size() == 0;
                if (logger.isLoggable(Level.FINE)) {
                    if (content.isEntity()) {
                        logger.fine("processing entity '" + content.getLocation() + "' for document '" + content.getUri() + "'");
                    } else {
                        logger.fine("processing '" + content.getUri() + "'");
                    }
                }
                this.resetHttpChannel(http, request, options, content, commit, first, logger);
                this.issueRequest(http, content, commit, logger);
                int code = http.getResponseCode();
                SessionImpl session = (SessionImpl)request.getSession();
                session.setServerVersion(http.getServerVersion());
                if (!session.readCookieValues(http)) {
                    String version = session.getServerVersion();
                    throw new RequestServerException("Incompatible server version " + version == null ? "" : version + ".  Make sure to set xcc.txn.compatible to true", request);
                }
                entityContent = null;
                try {
                    ResponseHandler handler = this.findHandler(code);
                    entityContent = (ContentDecorator)handler.handleResponse(http, code, request, content, logger);
                    first = false;
                }
                catch (RetryableQueryException e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Retryable query exception caught.", e);
                    }
                    throw e;
                }
                catch (RequestServerException e) {
                    if (this.collectErrors) {
                        if (this.errorList == null) {
                            this.errorList = new ArrayList<RequestException>();
                        }
                        this.errorList.add(new ContentInsertException(e.getMessage(), e.getRequest(), content.content, e));
                        break block23;
                    }
                    throw e;
                }
                finally {
                    String connectionClose;
                    if (connection.isOpen()) {
                        if (!commit) {
                            http.setCommit(false);
                        }
                        this.setConnectionTimeout(connection, http);
                    }
                    if ((connectionClose = http.getResponseConnection()) != null && connectionClose.equalsIgnoreCase("close")) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Connection:closed header seen. Closing connection...");
                        }
                        connectionReplaced = true;
                        connection.close();
                        provider.returnConnection(connection, logger);
                        connection = provider.obtainConnection(session, request, logger);
                        http = new HttpChannel(connection.channel(), "PUT", this.httpPath, 0, options.getTimeoutMillis(), logger);
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Connection keep-alive seconds: " + http.getResponseKeepaliveSeconds());
                    }
                }
            }
            if (!content.isEntity()) {
                this.processedContent.add(content);
            }
            if (entityContent == null) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("queueing entity content for '" + entityContent.getUri() + "', location: " + entityContent.getLocation());
            }
            remaining.addFirst(entityContent);
        }
        if (connectionReplaced) {
            provider.returnConnection(connection, logger);
        }
        this.closeContent(this.processedContent);
        logger.fine("finished content insert dialog, " + this.contents.length + " documents successfully inserted");
        return null;
    }

    private void resetHttpChannel(HttpChannel http, Request request, RequestOptions options, Content content, boolean commit, boolean first, Logger logger) {
        boolean errOk = this.collectErrors;
        SessionImpl session = (SessionImpl)request.getSession();
        if (this.collectErrors) {
            boolean bl = session.getTxnID() != null ? true : (errOk = !first);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("session.getTxnID()=" + session.getTxnID() + ", first=" + first + ", errOk=" + errOk);
            }
        }
        String pathUri = content.getUri() == null ? null : ContentInsertController.makeReqUri(content, request, commit, errOk, this.httpPath);
        String method = "PUT";
        http.reset(method, pathUri);
        ContentCreateOptions copt = content.getCreateOptions();
        if (copt != null && !"UTF-8".equalsIgnoreCase(copt.getEncoding())) {
            http.setRequestContentType("text/xml; charset=" + copt.getEncoding());
        } else {
            http.setRequestContentType("text/xml");
        }
        this.addCommonHeaders(http, session, method, pathUri, options, logger);
        http.setRequestHeader("Connection", "keep-alive");
        if (HttpChannel.isUseHTTP()) {
            http.setRequestHeader("Transfer-Encoding", "chunked");
        }
    }

    private void issueRequest(HttpChannel http, ContentDecorator content, boolean commit, Logger logger) throws IOException {
        int rc;
        String uri = content.getUri();
        if (logger.isLoggable(Level.FINE)) {
            if (content.isEntity()) {
                logger.fine("sending entity (location=" + content.getLocation() + ") for uri=" + uri + ", size=" + content.size());
            } else {
                logger.fine("sending content: uri=" + uri + ", size=" + content.size());
            }
        }
        ByteBuffer dataBuffer = this.allocDataBuffer(content);
        byte[] dataBytes = dataBuffer.array();
        InputStream inStream = content.openDataStream();
        boolean checkBOM = this.mayHaveBOM(content);
        if (content.isEntity()) {
            http.suppressHeaders();
        }
        while ((rc = inStream.read(dataBytes)) > 0) {
            dataBuffer.clear();
            dataBuffer.limit(rc);
            if (checkBOM) {
                checkBOM = false;
                if (rc >= 3 && this.hasBOM(dataBytes)) {
                    rc -= 3;
                    dataBuffer.position(3);
                    logger.finest("suppressed UTF-8 BOM");
                }
            }
            this.writeChunkHeader(http, 0, rc, logger);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("writing " + rc + " bytes of data");
            }
            http.write(dataBuffer);
            if (!HttpChannel.isUseHTTP()) continue;
            http.write("\r\n".getBytes());
        }
        inStream.close();
        this.writeChunkHeader(http, commit ? 1 : 2, 0, logger);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("finished sending content: commit=" + commit);
        }
    }

    private boolean mayHaveBOM(ContentDecorator content) {
        ContentCreateOptions options = content.getCreateOptions();
        String encoding = options == null ? "utf-8" : options.getEncoding();
        DocumentFormat fmt = options == null ? DocumentFormat.NONE : options.getFormat();
        boolean isUtf8 = options == null || "utf-8".equalsIgnoreCase(encoding) || "utf8".equalsIgnoreCase(encoding);
        return isUtf8 && fmt != DocumentFormat.BINARY && fmt != DocumentFormat.NONE;
    }

    private boolean hasBOM(byte[] bytes) {
        return (bytes[0] & 0xFF) == 239 && (bytes[1] & 0xFF) == 187 && (bytes[2] & 0xFF) == 191;
    }

    private void assertRestartable(LinkedList<Content> processedContent, Request request) throws ContentInsertException {
        while (processedContent.size() > 0) {
            ContentDecorator content = (ContentDecorator)processedContent.removeFirst();
            if (content.isPristine()) continue;
            if (content.isRewindable()) {
                try {
                    content.rewind();
                    continue;
                }
                catch (IOException e) {
                    processedContent.clear();
                    throw new ContentInsertException("Cannot auto-restart insert, error rewinding content: " + content.getUri(), request, content.getOriginal(), e);
                }
            }
            processedContent.clear();
            throw new ContentInsertException("Cannot auto-restart insert, non-rewindable content already processed: " + content.getUri(), request, content.getOriginal());
        }
    }

    private void closeContent(LinkedList<Content> processedContent) {
        while (processedContent.size() > 0) {
            Content content = processedContent.removeFirst();
            content.close();
        }
    }

    private LinkedList<ContentDecorator> toLinkedList(Content[] array) {
        Content first;
        LinkedList<ContentDecorator> list = new LinkedList<ContentDecorator>();
        if (array.length > 0 && !(first = array[0]).isRewindable()) {
            list.add(new ContentDecorator(ContentFactory.newContent(first.getUri(), new byte[0], first.getCreateOptions())));
        }
        for (int i = 0; i < array.length; ++i) {
            list.add(new ContentDecorator(array[i]));
        }
        return list;
    }

    ByteBuffer allocDataBuffer(Content content) {
        ContentCreateOptions options = content.getCreateOptions();
        int userSize = options == null ? -1 : options.getBufferSize();
        long bufSize = content.size() == -1L ? 131072L : content.size();
        bufSize = userSize == -1 ? bufSize : Math.min(bufSize, (long)userSize);
        bufSize = Math.min(bufSize, 0xC00000L);
        if (this.dataBuffer == null || (long)this.dataBuffer.capacity() < bufSize) {
            this.dataBuffer = ByteBuffer.allocate((int)bufSize);
        }
        return this.dataBuffer;
    }

    static String makeReqUri(Content content, Request request, boolean commit, boolean collectErrors, String httpPath) {
        int i;
        ContentCreateOptions options = content.getCreateOptions() == null ? new ContentCreateOptions() : content.getCreateOptions();
        RequestOptions requestOptions = request == null ? new RequestOptions() : request.getEffectiveOptions();
        StringBuffer sb = new StringBuffer(256);
        HttpChannel.addPathSegment(sb, httpPath);
        HttpChannel.addPathSegment(sb, "/insert?uri=");
        IOHelper.urlEncodeToStringBuffer(sb, content.getUri());
        if (!commit) {
            sb.append("&nocommit");
        }
        if (collectErrors) {
            sb.append("&errok");
        }
        if (options.getLocale() != null) {
            if (request == null) {
                sb.append("&locale=").append(options.getLocale().toString());
            } else {
                requestOptions.setLocale(options.getLocale());
            }
        }
        if (options.getLanguage() != null) {
            sb.append("&lang=");
            IOHelper.urlEncodeToStringBuffer(sb, options.getLanguage());
        }
        if (options.getNamespace() != null) {
            sb.append("&defaultns=");
            IOHelper.urlEncodeToStringBuffer(sb, options.getNamespace());
        }
        if (options.getQuality() != 0) {
            sb.append("&quality=").append(options.getQuality());
        }
        if (options.getResolveEntities()) {
            sb.append("&resolve");
        }
        if (options.getResolveBufferSize() != 0) {
            sb.append("&resolvesiz=").append(options.getResolveBufferSize());
        }
        if (options.getRepairLevel() == DocumentRepairLevel.NONE) {
            sb.append("&repair=none");
        }
        if (options.getRepairLevel() == DocumentRepairLevel.FULL) {
            sb.append("&repair=full");
        }
        if (options.getFormat() == DocumentFormat.XML) {
            sb.append("&format=xml");
        }
        if (options.getFormat() == DocumentFormat.JSON) {
            sb.append("&format=json");
        }
        if (options.getFormat() == DocumentFormat.TEXT) {
            sb.append("&format=text");
        }
        if (options.getFormat() == DocumentFormat.BINARY) {
            sb.append("&format=binary");
        }
        if (options.getPlaceKeys() != null) {
            BigInteger[] keys = options.getPlaceKeys();
            for (i = 0; i < keys.length; ++i) {
                sb.append("&placeKey=").append(keys[i].toString());
            }
        }
        if (options.getCollections() != null) {
            String[] collections = options.getCollections();
            if (collections.length == 0) {
                sb.append("&nocolls");
            } else {
                for (i = 0; i < collections.length; ++i) {
                    sb.append("&coll=");
                    IOHelper.urlEncodeToStringBuffer(sb, collections[i]);
                }
            }
        }
        if (options.getPermissions() != null) {
            ContentPermission[] perms = options.getPermissions();
            if (perms.length == 0) {
                sb.append("&noperms");
            } else {
                for (i = 0; i < perms.length; ++i) {
                    ContentPermission perm = perms[i];
                    String symbol = perm.getCapability() == null ? "N" : perm.getCapability().getSymbol();
                    sb.append("&perm=").append(symbol);
                    IOHelper.urlEncodeToStringBuffer(sb, perm.getRole());
                }
            }
        }
        if (options.getMetadata() != null) {
            Map<String, String> meta = options.getMetadata();
            Set<String> keys = options.getMetadata().keySet();
            Iterator<String> it = keys.iterator();
            while (it.hasNext()) {
                sb.append("&metakey=");
                String key = it.next();
                IOHelper.urlEncodeToStringBuffer(sb, key);
                sb.append("&metaval=");
                IOHelper.urlEncodeToStringBuffer(sb, meta.get(key));
            }
        }
        if (options.getTemporalCollection() != null) {
            sb.append("&temporalcoll=");
            IOHelper.urlEncodeToStringBuffer(sb, options.getTemporalCollection());
            if (options.getTemporalVersionURI() != null) {
                sb.append("&temporalvuri=");
                IOHelper.urlEncodeToStringBuffer(sb, options.getTemporalVersionURI());
            }
        }
        if (options.getGraph() != null) {
            sb.append("&graph=");
            IOHelper.urlEncodeToStringBuffer(sb, options.getGraph());
        }
        if (request != null) {
            ((RequestImpl)request).encodeQueryOptions(sb, requestOptions);
            ((RequestImpl)request).encodeTxn(sb);
        }
        return sb.substring(0);
    }

    public List<RequestException> getErrors() {
        return this.errorList;
    }

    static {
        ContentInsertController.addDefaultHandler(handlers, new UnrecognizedCodeHandler());
        ContentInsertController.addHandler(handlers, 503, new ServiceUnavailableHandler());
        ContentInsertController.addHandler(handlers, 502, new ServiceUnavailableHandler());
        ContentInsertController.addHandler(handlers, 504, new ServiceUnavailableHandler());
        ContentInsertController.addHandler(handlers, 500, new ServerExceptionHandler());
        ContentInsertController.addHandler(handlers, 401, new UnauthorizedHandler());
        ContentInsertController.addHandler(handlers, 404, new NotFoundCodeHandler());
        ContentInsertController.addHandler(handlers, 400, new NotFoundCodeHandler());
        ContentInsertController.addHandler(handlers, 200, new GoodInsertResponseHandler());
        ContentInsertController.addHandler(handlers, 307, new EntityResolveHandler());
        ContentInsertController.addHandler(handlers, 415, new UnSupportedTypeHandler());
        ContentInsertController.addHandler(handlers, 405, new BadMethodHandler());
        ContentInsertController.addHandler(handlers, 413, new EntityTooLargeHandler());
        ContentInsertController.addHandler(handlers, 403, new PDCloudForbiddenHandler());
        ContentInsertController.addHandler(handlers, 410, new PDCloudGoneHandler());
    }

    static class ContentDecorator
    implements Content {
        final Content content;
        private final Content parent;
        private final String location;
        private boolean pristine = true;

        public ContentDecorator(Content content) {
            this.content = content;
            this.parent = null;
            this.location = null;
        }

        public ContentDecorator(Content entity, Content parent, String location) {
            this.content = entity;
            this.parent = parent;
            this.location = location;
        }

        @Override
        public String getUri() {
            return this.parent == null ? this.content.getUri() : this.parent.getUri();
        }

        @Override
        public InputStream openDataStream() throws IOException {
            this.pristine = false;
            return this.content.openDataStream();
        }

        @Override
        public ContentCreateOptions getCreateOptions() {
            return this.content.getCreateOptions();
        }

        @Override
        public boolean isRewindable() {
            return this.content.isRewindable();
        }

        @Override
        public void rewind() throws IOException {
            this.pristine = false;
            this.content.rewind();
        }

        @Override
        public long size() {
            return this.content.size();
        }

        @Override
        public void close() {
            this.pristine = false;
            this.content.close();
        }

        public boolean isEntity() {
            return this.location != null;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean isPristine() {
            return this.pristine;
        }

        public Content getOriginal() {
            return this.content;
        }
    }
}

