/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.io.ResourcePool;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.impl.SimpleConnection;
import com.marklogic.xcc.spi.ConnectionErrorAction;
import com.marklogic.xcc.spi.ConnectionProvider;
import com.marklogic.xcc.spi.ServerConnection;
import com.marklogic.xcc.spi.SingleHostAddress;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SocketPoolProvider
implements ConnectionProvider,
SingleHostAddress {
    private static final int DEFAULT_SOCKET_POOL_SIZE = 64;
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 131072;
    private static final String POOL_SIZE_PROPERTY = "xcc.socket.pool.max";
    private static final String SOCKET_SEND_BUFFER_PROPERTY = "xcc.socket.sendbuf";
    private static final String SOCKET_RECV_BUFFER_PROPERTY = "xcc.socket.recvbuf";
    private final int poolSize = Integer.getInteger("xcc.socket.pool.max", 64);
    private static final int socketSendBuffSize = Integer.getInteger("xcc.socket.sendbuf", 131072);
    private static final int socketRecvBuffSize = Integer.getInteger("xcc.socket.recvbuf", 131072);
    private final ResourcePool<SocketAddress, SocketChannel> connectionPool;
    private SocketAddress address;
    private final Logger logger = Logger.getLogger(ConnectionProvider.class.getName());

    public SocketPoolProvider(SocketAddress address) {
        this.logger.fine("constructing new SocketPoolProvider");
        this.address = address;
        this.connectionPool = new ResourcePool();
    }

    public SocketPoolProvider(String host, int port) {
        this(new InetSocketAddress(host, port));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof SocketPoolProvider)) {
            return false;
        }
        return this.address.equals(((SocketPoolProvider)o).getAddress());
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    int getPoolSize() {
        return this.poolSize;
    }

    @Override
    public ServerConnection obtainConnection(Session session, Request request, Logger logger) throws IOException {
        if (this.getLogger(logger).isLoggable(Level.FINE)) {
            this.getLogger(logger).fine("obtainConnection for " + this.address);
        }
        this.getAddress();
        SocketChannel channel = this.connectionPool.get(this.address);
        if (channel == null) {
            RequestOptions options;
            int timeout;
            if (this.getLogger(logger).isLoggable(Level.FINE)) {
                this.getLogger(logger).fine("No available channel, getting new socket channel for " + this.address);
            }
            channel = SocketChannel.open(this.address);
            Socket socket = channel.socket();
            socket.setSendBufferSize(socketSendBuffSize);
            socket.setReceiveBufferSize(socketRecvBuffSize);
            socket.setTcpNoDelay(true);
            socket.setSoLinger(false, 0);
            socket.setKeepAlive(true);
            if (request != null && (timeout = (options = request.getEffectiveOptions()).getTimeoutMillis()) >= 0) {
                socket.setSoTimeout(timeout);
            }
            this.getLogger(logger).fine("  pool empty, created new connection");
        } else {
            this.getLogger(logger).fine("  using connection from pool");
        }
        return new SimpleConnection(channel, this);
    }

    @Override
    public void returnConnection(ServerConnection connection, Logger logger) {
        ByteChannel channel;
        if (this.getLogger(logger).isLoggable(Level.FINE)) {
            this.getLogger(logger).fine("returnConnection for " + this.address + ", expire=" + connection.getTimeoutMillis());
        }
        if ((channel = connection.channel()) == null || !(channel instanceof SocketChannel)) {
            this.getLogger(logger).fine("channel is not eligible for pooling, dropping");
            return;
        }
        SocketChannel socketChannel = (SocketChannel)channel;
        Socket socket = socketChannel.socket();
        int localPort = socket.getLocalPort();
        if (!socketChannel.isOpen() || socket.isInputShutdown() || socket.isOutputShutdown()) {
            if (socketChannel.isOpen()) {
                if (this.getLogger(logger).isLoggable(Level.FINE)) {
                    this.getLogger(logger).fine("channel has been shutdown but not closed: closing and dropping. local-port=" + localPort);
                }
                connection.close();
            } else {
                this.getLogger(logger).fine("channel has been closed, dropping. local-port=" + localPort);
            }
            return;
        }
        long timeoutMillis = connection.getTimeoutMillis();
        if (timeoutMillis <= 0L) {
            this.getLogger(logger).fine("channel has already expired, closing. local-port=" + localPort);
            connection.close();
            return;
        }
        long timeoutTime = connection.getTimeoutTime();
        if (this.getLogger(logger).isLoggable(Level.FINE)) {
            this.getLogger(logger).fine("returning socket to pool (" + this.address + "), timeout time=" + timeoutTime + " local-port=" + localPort);
        }
        this.connectionPool.put(this.address, (SocketChannel)channel, timeoutTime);
    }

    @Override
    public ConnectionErrorAction returnErrorConnection(ServerConnection connection, Throwable exception, Logger logger) {
        ByteChannel channel;
        if (this.getLogger(logger).isLoggable(Level.FINE)) {
            this.getLogger(logger).log(Level.FINE, "error return", exception);
        }
        if ((channel = connection.channel()) != null) {
            if (channel.isOpen()) {
                try {
                    channel.close();
                    this.getLogger(logger).fine("closed error connection");
                }
                catch (IOException iOException) {}
            } else {
                this.getLogger(logger).warning("returned error connection is closed, retrying");
                return ConnectionErrorAction.RETRY;
            }
        }
        if (this.getLogger(logger).isLoggable(Level.FINE)) {
            this.getLogger(logger).fine("returning FAIL action");
        }
        return ConnectionErrorAction.FAIL;
    }

    @Override
    public void shutdown(Logger logger) {
        SocketChannel channel;
        this.getLogger(logger).fine("shutting down socket pool provider");
        while ((channel = this.connectionPool.get(this.address)) != null) {
            try {
                channel.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        return "address=" + this.address.toString() + ", pool=" + this.connectionPool.size(this.address) + "/" + this.poolSize;
    }

    @Override
    public InetSocketAddress getAddress() {
        if (!(this.address instanceof InetSocketAddress)) {
            return null;
        }
        try {
            InetSocketAddress cachedInetSocketAddress = (InetSocketAddress)this.address;
            InetAddress currInetAddress = InetAddress.getByName(cachedInetSocketAddress.getHostName());
            if (!cachedInetSocketAddress.getAddress().equals(currInetAddress)) {
                this.getLogger(this.logger).info("Current InetAddress and Cached InetAddress do not match. Cached InetAddress: " + cachedInetSocketAddress.getAddress().getHostAddress() + ". Current InetAddress: " + currInetAddress.getHostAddress() + ". So IP address is updated");
                this.address = new InetSocketAddress(currInetAddress, cachedInetSocketAddress.getPort());
            }
        }
        catch (UnknownHostException e) {
            this.getLogger(this.logger).warning("Exception thrown during IP address update, Hostname unresolvable. " + e.getMessage());
            e.printStackTrace();
        }
        return (InetSocketAddress)this.address;
    }

    private Logger getLogger(Logger clientLogger) {
        return clientLogger == null ? this.logger : clientLogger;
    }

    @Override
    public void closeExpired(long currTime) {
        this.connectionPool.closeExpired(currTime);
    }

    @Override
    public int getPort() {
        InetSocketAddress inetAddress = this.getAddress();
        return inetAddress == null ? 0 : inetAddress.getPort();
    }

    @Override
    public String getHostName() {
        InetSocketAddress inetAddress = this.getAddress();
        return inetAddress == null ? null : inetAddress.getHostName();
    }
}

