/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.exceptions;

import com.marklogic.xcc.Request;
import com.marklogic.xcc.Version;
import com.marklogic.xcc.exceptions.XccException;
import com.marklogic.xcc.impl.SessionImpl;

public class RequestException
extends XccException {
    private static final long serialVersionUID = -7193834172330203276L;
    private transient Request request;
    private final boolean isRetryable;

    public RequestException(String message, Request request) {
        this(message, request, false);
    }

    public RequestException(String message, Request request, Throwable cause) {
        this(message, request, cause, false);
    }

    public RequestException(String message, Request request, boolean isRetryable) {
        super(message);
        this.request = request;
        this.isRetryable = isRetryable;
    }

    public RequestException(String message, Request request, Throwable cause, boolean isRetryable) {
        super(message, cause);
        this.request = request;
        this.isRetryable = isRetryable;
    }

    public Request getRequest() {
        return this.request;
    }

    public boolean isRetryable() {
        return this.isRetryable;
    }

    public boolean isRetryAdvised() {
        return this.isRetryable;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        this.appendRequestInfo(sb);
        return sb.toString();
    }

    protected void appendRequestInfo(StringBuffer sb) {
        String nl = System.getProperty("line.separator");
        String serverVersion = ((SessionImpl)this.request.getSession()).getServerVersion();
        sb.append(nl);
        sb.append(" [Session: ");
        sb.append(this.request.getSession().toString());
        sb.append("]");
        sb.append(nl);
        sb.append(" [Client: XCC/");
        sb.append(Version.getVersionString());
        if (serverVersion != null) {
            sb.append(", Server: XDBC/");
            sb.append(serverVersion);
        }
        sb.append("]");
    }
}

