/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc;

import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.types.ArrayNode;
import com.marklogic.xcc.types.AtomicType;
import com.marklogic.xcc.types.BooleanNode;
import com.marklogic.xcc.types.CtsBox;
import com.marklogic.xcc.types.CtsCircle;
import com.marklogic.xcc.types.CtsPoint;
import com.marklogic.xcc.types.CtsPolygon;
import com.marklogic.xcc.types.Duration;
import com.marklogic.xcc.types.JSArray;
import com.marklogic.xcc.types.JSNull;
import com.marklogic.xcc.types.JSObject;
import com.marklogic.xcc.types.NodeType;
import com.marklogic.xcc.types.NullNode;
import com.marklogic.xcc.types.NumberNode;
import com.marklogic.xcc.types.ObjectNode;
import com.marklogic.xcc.types.SequenceType;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.VecVector;
import com.marklogic.xcc.types.XName;
import com.marklogic.xcc.types.XSBoolean;
import com.marklogic.xcc.types.XSDate;
import com.marklogic.xcc.types.XSDateTime;
import com.marklogic.xcc.types.XSDuration;
import com.marklogic.xcc.types.XSInteger;
import com.marklogic.xcc.types.XSString;
import com.marklogic.xcc.types.XSTime;
import com.marklogic.xcc.types.XdmAtomic;
import com.marklogic.xcc.types.XdmBinary;
import com.marklogic.xcc.types.XdmComment;
import com.marklogic.xcc.types.XdmDocument;
import com.marklogic.xcc.types.XdmDuration;
import com.marklogic.xcc.types.XdmElement;
import com.marklogic.xcc.types.XdmItem;
import com.marklogic.xcc.types.XdmNode;
import com.marklogic.xcc.types.XdmProcessingInstruction;
import com.marklogic.xcc.types.XdmSequence;
import com.marklogic.xcc.types.XdmText;
import com.marklogic.xcc.types.XdmValue;
import com.marklogic.xcc.types.XdmVariable;
import com.marklogic.xcc.types.impl.ArrayNodeImpl;
import com.marklogic.xcc.types.impl.BinaryImpl;
import com.marklogic.xcc.types.impl.BooleanNodeImpl;
import com.marklogic.xcc.types.impl.CommentImpl;
import com.marklogic.xcc.types.impl.CtsBoxImpl;
import com.marklogic.xcc.types.impl.CtsCircleImpl;
import com.marklogic.xcc.types.impl.CtsPointImpl;
import com.marklogic.xcc.types.impl.CtsPolygonImpl;
import com.marklogic.xcc.types.impl.DocumentImpl;
import com.marklogic.xcc.types.impl.ElementImpl;
import com.marklogic.xcc.types.impl.JSArrayImpl;
import com.marklogic.xcc.types.impl.JSNullImpl;
import com.marklogic.xcc.types.impl.JSObjectImpl;
import com.marklogic.xcc.types.impl.NullNodeImpl;
import com.marklogic.xcc.types.impl.NumberNodeImpl;
import com.marklogic.xcc.types.impl.ObjectNodeImpl;
import com.marklogic.xcc.types.impl.ProcessingInstructionImpl;
import com.marklogic.xcc.types.impl.SequenceImpl;
import com.marklogic.xcc.types.impl.TextImpl;
import com.marklogic.xcc.types.impl.VecVectorImpl;
import com.marklogic.xcc.types.impl.XsAnyUriImpl;
import com.marklogic.xcc.types.impl.XsBase64BinaryImpl;
import com.marklogic.xcc.types.impl.XsBooleanImpl;
import com.marklogic.xcc.types.impl.XsDateImpl;
import com.marklogic.xcc.types.impl.XsDateTimeImpl;
import com.marklogic.xcc.types.impl.XsDayTimeDurationImpl;
import com.marklogic.xcc.types.impl.XsDecimalImpl;
import com.marklogic.xcc.types.impl.XsDoubleImpl;
import com.marklogic.xcc.types.impl.XsDurationImpl;
import com.marklogic.xcc.types.impl.XsFloatImpl;
import com.marklogic.xcc.types.impl.XsGDayImpl;
import com.marklogic.xcc.types.impl.XsGMonthDayImpl;
import com.marklogic.xcc.types.impl.XsGMonthImpl;
import com.marklogic.xcc.types.impl.XsGYearImpl;
import com.marklogic.xcc.types.impl.XsGYearMonthImpl;
import com.marklogic.xcc.types.impl.XsHexBinaryImpl;
import com.marklogic.xcc.types.impl.XsIntegerImpl;
import com.marklogic.xcc.types.impl.XsQNameImpl;
import com.marklogic.xcc.types.impl.XsStringImpl;
import com.marklogic.xcc.types.impl.XsTimeImpl;
import com.marklogic.xcc.types.impl.XsUntypedAtomicImpl;
import com.marklogic.xcc.types.impl.XsYearMonthDurationImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class ValueFactory {
    private ValueFactory() {
    }

    public static XdmValue newValue(ValueType valueType, Object value) {
        if (valueType instanceof SequenceType) {
            return ValueFactory.newSequenceValue(value);
        }
        if (valueType instanceof NodeType) {
            return ValueFactory.newNodeValue(valueType, value);
        }
        if (valueType instanceof AtomicType) {
            return ValueFactory.newAtomicValue(valueType, value);
        }
        throw new IllegalArgumentException("Unrecognized ValueType: " + valueType);
    }

    public static XdmElement newElement(Object value) {
        if (value instanceof String) {
            return new ElementImpl((String)value);
        }
        if (value instanceof InputStream) {
            return new ElementImpl((InputStream)value);
        }
        if (value instanceof Element) {
            byte[] bytes = ContentFactory.bytesFromW3cNode((Element)value);
            return new ElementImpl(new ByteArrayInputStream(bytes));
        }
        throw new IllegalArgumentException("String, org.w3c.dom.Element or InputStream value required to construct " + ValueType.ELEMENT);
    }

    public static XdmDocument newDocumentNode(Object value) {
        if (value instanceof String) {
            return new DocumentImpl((String)value);
        }
        if (value instanceof InputStream) {
            return new DocumentImpl((InputStream)value);
        }
        if (value instanceof Document) {
            byte[] bytes = ContentFactory.bytesFromW3cNode((Document)value);
            return new DocumentImpl(new ByteArrayInputStream(bytes));
        }
        throw new IllegalArgumentException("String, org.w3c.dom.Document or InputStream value required to construct " + ValueType.DOCUMENT);
    }

    public static XdmText newTextNode(Object value) {
        if (value instanceof String) {
            return new TextImpl((String)value);
        }
        if (value instanceof InputStream) {
            return new TextImpl((InputStream)value);
        }
        if (value instanceof Text) {
            Text text = (Text)value;
            return new TextImpl(text.getNodeValue());
        }
        throw new IllegalArgumentException("String, org.w3c.dom.Text or InputStream value required to construct " + ValueType.TEXT);
    }

    public static XdmComment newCommentNode(Object value) {
        if (value instanceof String) {
            return new CommentImpl((String)value);
        }
        if (value instanceof InputStream) {
            return new CommentImpl((InputStream)value);
        }
        if (value instanceof Comment) {
            Comment c = (Comment)value;
            return new CommentImpl(c.getNodeValue());
        }
        throw new IllegalArgumentException("String, org.w3c.dom.Text or InputStream value required to construct " + ValueType.TEXT);
    }

    public static XdmProcessingInstruction newProcessingInstructionNode(Object value) {
        if (value instanceof String) {
            return new ProcessingInstructionImpl((String)value);
        }
        if (value instanceof InputStream) {
            return new ProcessingInstructionImpl((InputStream)value);
        }
        if (value instanceof ProcessingInstruction) {
            ProcessingInstruction c = (ProcessingInstruction)value;
            return new ProcessingInstructionImpl(c.getNodeValue());
        }
        throw new IllegalArgumentException("String, org.w3c.dom.Text or InputStream value required to construct " + ValueType.TEXT);
    }

    public static XdmBinary newBinaryNode(Object value) {
        if (value instanceof String) {
            byte[] bytes = null;
            try {
                bytes = ((String)value).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                bytes = ((String)value).getBytes();
            }
            return new BinaryImpl(new ByteArrayInputStream(bytes), true);
        }
        if (value instanceof byte[]) {
            return new BinaryImpl(new ByteArrayInputStream((byte[])value), true);
        }
        if (value instanceof InputStream) {
            return new BinaryImpl((InputStream)value, true);
        }
        throw new IllegalArgumentException("String, org.w3c.dom.Text or InputStream value required to construct " + ValueType.BINARY);
    }

    public static ArrayNode newArrayNode(Object value) {
        if (value instanceof ArrayNode) {
            return (ArrayNode)value;
        }
        if (value instanceof String) {
            return new ArrayNodeImpl((String)value);
        }
        if (value instanceof InputStream) {
            return new ArrayNodeImpl((InputStream)value);
        }
        if (value instanceof com.fasterxml.jackson.databind.node.ArrayNode) {
            return new ArrayNodeImpl(value.toString());
        }
        throw new IllegalArgumentException("String, com.fasterxml.jackson.databind.node.ArrayNode or InputStream value required to construct " + ValueType.ARRAY_NODE);
    }

    public static BooleanNode newBooleanNode(Object value) {
        if (value instanceof BooleanNode) {
            return (BooleanNode)value;
        }
        if (value instanceof String) {
            return new BooleanNodeImpl((String)value);
        }
        if (value instanceof InputStream) {
            return new BooleanNodeImpl((InputStream)value);
        }
        if (value instanceof com.fasterxml.jackson.databind.node.BooleanNode) {
            return new BooleanNodeImpl(value.toString());
        }
        throw new IllegalArgumentException("String, com.fasterxml.jackson.databind.node.BooleanNode or InputStream value required to construct " + ValueType.BOOLEAN_NODE);
    }

    public static BooleanNode newBooleanNode(boolean value) {
        return new BooleanNodeImpl(value ? "true" : "false");
    }

    public static XSString newXSString(String value) {
        return (XSString)ValueFactory.newValue(ValueType.XS_STRING, value);
    }

    public static XSInteger newXSInteger(long value) {
        return (XSInteger)ValueFactory.newValue(ValueType.XS_INTEGER, new Long(value));
    }

    public static XSInteger newXSInteger(BigInteger value) {
        return (XSInteger)ValueFactory.newValue(ValueType.XS_INTEGER, value);
    }

    public static XSBoolean newXSBoolean(boolean value) {
        return new XsBooleanImpl(value);
    }

    public static CtsBox newCtsBox(String south, String west, String north, String east) {
        return new CtsBoxImpl(south, west, north, east);
    }

    public static CtsCircle newCtsCircle(String radius, CtsPoint center) {
        return new CtsCircleImpl(radius, center);
    }

    public static CtsPoint newCtsPoint(String latitude, String longitude) {
        return new CtsPointImpl(latitude, longitude);
    }

    public static CtsPolygon newCtsPolygon(List<CtsPoint> vertices) {
        return new CtsPolygonImpl(vertices);
    }

    public static VecVector newVecVector(float[] values) {
        return new VecVectorImpl(values);
    }

    public static XSDateTime newXSDateTime(String value, TimeZone timeZone, Locale locale) {
        return new XsDateTimeImpl(value, timeZone, locale);
    }

    public static XSDate newXSDate(String value, TimeZone timeZone, Locale locale) {
        return new XsDateImpl(value, timeZone, locale);
    }

    public static XSTime newXSTime(String value, TimeZone timeZone, Locale locale) {
        return new XsTimeImpl(value, timeZone, locale);
    }

    public static XSDuration newXSDuration(String value) {
        return new XsDurationImpl(value);
    }

    public static XSDuration newXSDuration(XdmDuration duration) {
        return ValueFactory.newXSDuration(duration.toString());
    }

    public static XdmDuration newDuration(String serializedString) {
        return new Duration(serializedString);
    }

    public static JSObject newJSObject(String serializedString) {
        return new JSObjectImpl(serializedString);
    }

    public static JSObject newJSObject(com.fasterxml.jackson.databind.node.ObjectNode value) {
        return new JSObjectImpl(value.toString());
    }

    public static JSArray newJSArray(String serializedString) {
        return new JSArrayImpl(serializedString);
    }

    public static JSArray newJSArray(com.fasterxml.jackson.databind.node.ArrayNode value) {
        return new JSArrayImpl(value.toString());
    }

    public static JSNull newJSNull() {
        return new JSNullImpl();
    }

    public static XdmSequence<XdmItem> newSequence(XdmValue[] values) {
        return new SequenceImpl(values);
    }

    public static XdmVariable newVariable(XName name, XdmValue value) {
        return new XdmVar(name, value);
    }

    private static XdmSequence<XdmItem> newSequenceValue(Object values) {
        if (!(values instanceof XdmValue[])) {
            throw new IllegalArgumentException("Value must be array of XdmValue");
        }
        return ValueFactory.newSequence((XdmValue[])values);
    }

    private static XdmNode newNodeValue(ValueType valueType, Object value) {
        if (valueType == ValueType.ELEMENT) {
            return ValueFactory.newElement(value);
        }
        if (valueType == ValueType.NODE) {
            return ValueFactory.newElement(value);
        }
        if (valueType == ValueType.OBJECT_NODE) {
            return ValueFactory.newObjectNode(value);
        }
        if (valueType == ValueType.NULL_NODE) {
            return ValueFactory.newNullNode(value);
        }
        if (valueType == ValueType.BOOLEAN_NODE) {
            return ValueFactory.newBooleanNode(value);
        }
        if (valueType == ValueType.ARRAY_NODE) {
            return ValueFactory.newArrayNode(value);
        }
        if (valueType == ValueType.NUMBER_NODE) {
            return ValueFactory.newNumberNode(value);
        }
        if (valueType == ValueType.TEXT) {
            return ValueFactory.newTextNode(value);
        }
        if (valueType == ValueType.BINARY) {
            return ValueFactory.newBinaryNode(value);
        }
        if (valueType == ValueType.COMMENT) {
            return ValueFactory.newCommentNode(value);
        }
        if (valueType == ValueType.DOCUMENT) {
            return ValueFactory.newDocumentNode(value);
        }
        if (valueType == ValueType.PROCESSING_INSTRUCTION) {
            return ValueFactory.newProcessingInstructionNode(value);
        }
        throw new InternalError("Unrecognized valueType: " + valueType);
    }

    public static NullNode newNullNode(Object value) {
        if (value instanceof NullNode) {
            return (NullNode)value;
        }
        if (value instanceof String) {
            return new NullNodeImpl((String)value);
        }
        if (value instanceof InputStream) {
            return new NullNodeImpl((InputStream)value);
        }
        if (value instanceof com.fasterxml.jackson.databind.node.NullNode) {
            return new NullNodeImpl(value.toString());
        }
        throw new IllegalArgumentException("String, com.fasterxml.jackson.databind.node.NullNode or InputStream value required to construct " + ValueType.NULL_NODE);
    }

    public static NumberNode newNumberNode(Object value) {
        if (value instanceof NumberNode) {
            return (NumberNode)value;
        }
        if (value instanceof String) {
            return new NumberNodeImpl((String)value);
        }
        if (value instanceof InputStream) {
            return new NumberNodeImpl((InputStream)value);
        }
        if (value instanceof NumericNode) {
            return new NumberNodeImpl(value.toString());
        }
        throw new IllegalArgumentException("String, com.fasterxml.jackson.databind.node.NumericNode or InputStream value required to construct " + ValueType.NUMBER_NODE);
    }

    public static NumberNode newNumberNode(double value) {
        return ValueFactory.newNumberNode(new DoubleNode(value));
    }

    public static XdmNode newObjectNode(Object value) {
        if (value instanceof ObjectNode) {
            return (ObjectNode)value;
        }
        if (value instanceof String) {
            return new ObjectNodeImpl((String)value);
        }
        if (value instanceof InputStream) {
            return new ObjectNodeImpl((InputStream)value);
        }
        if (value instanceof com.fasterxml.jackson.databind.node.ObjectNode) {
            return new ObjectNodeImpl(value.toString());
        }
        throw new IllegalArgumentException("String, com.fasterxml.jackson.databind.node.NumericNode or InputStream value required to construct " + ValueType.OBJECT_NODE);
    }

    private static XdmAtomic newAtomicValue(ValueType valueType, Object value) {
        if (valueType == ValueType.XS_STRING) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsStringImpl((String)value);
        }
        if (valueType == ValueType.XS_INTEGER) {
            return new XsIntegerImpl(value);
        }
        if (valueType == ValueType.XS_DECIMAL) {
            return new XsDecimalImpl(value);
        }
        if (valueType == ValueType.XS_DOUBLE) {
            return new XsDoubleImpl(value);
        }
        if (valueType == ValueType.XS_FLOAT) {
            return new XsFloatImpl(value);
        }
        if (valueType == ValueType.XS_BOOLEAN) {
            if (value instanceof Boolean) {
                return new XsBooleanImpl((Boolean)value);
            }
            if (value instanceof String) {
                return new XsBooleanImpl((String)value);
            }
            throw new IllegalArgumentException("Illegal value type (" + value.getClass() + "), must be Boolean or String");
        }
        if (valueType == ValueType.JS_ARRAY) {
            if (value instanceof String) {
                return new JSArrayImpl((String)value);
            }
            if (value instanceof com.fasterxml.jackson.databind.node.ArrayNode) {
                return new JSArrayImpl(value.toString());
            }
            throw new IllegalArgumentException("Illegal value type (" + value.getClass() + "), must be com.fasterxml.jackson.databind.node.ArrayNode or String");
        }
        if (valueType == ValueType.JS_OBJECT) {
            if (value instanceof String) {
                return new JSObjectImpl((String)value);
            }
            if (value instanceof com.fasterxml.jackson.databind.node.ObjectNode) {
                return new JSObjectImpl(value.toString());
            }
            throw new IllegalArgumentException("Illegal value type (" + value.getClass() + "), must be com.fasterxml.jackson.databind.node.ObjectNode or String");
        }
        if (valueType == ValueType.JS_NULL) {
            return new JSNullImpl();
        }
        if (valueType == ValueType.XS_ANY_URI) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsAnyUriImpl((String)value);
        }
        if (valueType == ValueType.XS_QNAME) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsQNameImpl((String)value);
        }
        if (valueType == ValueType.XS_UNTYPED_ATOMIC) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsUntypedAtomicImpl((String)value);
        }
        if (valueType == ValueType.XS_DURATION) {
            if (value instanceof XdmDuration) {
                return new XsDurationImpl(value.toString());
            }
            ValueFactory.assertStringArg(value, valueType);
            return new XsDurationImpl((String)value);
        }
        if (valueType == ValueType.XS_DAY_TIME_DURATION) {
            if (value instanceof XdmDuration) {
                return new XsDayTimeDurationImpl(value.toString());
            }
            ValueFactory.assertStringArg(value, valueType);
            return new XsDayTimeDurationImpl((String)value);
        }
        if (valueType == ValueType.XS_YEAR_MONTH_DURATION) {
            if (value instanceof XdmDuration) {
                return new XsYearMonthDurationImpl(value.toString());
            }
            ValueFactory.assertStringArg(value, valueType);
            return new XsYearMonthDurationImpl((String)value);
        }
        if (valueType == ValueType.XS_DATE_TIME) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsDateTimeImpl((String)value, TimeZone.getDefault(), Locale.getDefault());
        }
        if (valueType == ValueType.XS_DATE) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsDateImpl((String)value, TimeZone.getDefault(), Locale.getDefault());
        }
        if (valueType == ValueType.XS_TIME) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsTimeImpl((String)value, TimeZone.getDefault(), Locale.getDefault());
        }
        if (valueType == ValueType.XS_GDAY) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsGDayImpl((String)value, null, null);
        }
        if (valueType == ValueType.XS_GMONTH) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsGMonthImpl((String)value, null, null);
        }
        if (valueType == ValueType.XS_GMONTH_DAY) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsGMonthDayImpl((String)value, null, null);
        }
        if (valueType == ValueType.XS_GYEAR) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsGYearImpl((String)value, null, null);
        }
        if (valueType == ValueType.XS_GYEAR_MONTH) {
            ValueFactory.assertStringArg(value, valueType);
            return new XsGYearMonthImpl((String)value, null, null);
        }
        if (valueType == ValueType.XS_HEX_BINARY) {
            if (value instanceof byte[]) {
                return new XsHexBinaryImpl((byte[])value);
            }
            ValueFactory.assertStringArg(value, valueType);
            return new XsHexBinaryImpl((String)value);
        }
        if (valueType == ValueType.XS_BASE64_BINARY) {
            if (value instanceof byte[]) {
                return new XsBase64BinaryImpl((byte[])value);
            }
            ValueFactory.assertStringArg(value, valueType);
            return new XsBase64BinaryImpl((String)value);
        }
        if (valueType == ValueType.CTS_BOX) {
            ValueFactory.assertStringArg(value, valueType);
            return new CtsBoxImpl((String)value);
        }
        if (valueType == ValueType.CTS_CIRCLE) {
            ValueFactory.assertStringArg(value, valueType);
            return new CtsCircleImpl((String)value);
        }
        if (valueType == ValueType.CTS_POINT) {
            ValueFactory.assertStringArg(value, valueType);
            return new CtsPointImpl((String)value);
        }
        if (valueType == ValueType.CTS_POLYGON) {
            ValueFactory.assertStringArg(value, valueType);
            return new CtsPolygonImpl((String)value);
        }
        if (valueType == ValueType.VEC_VECTOR) {
            ValueFactory.assertStringArg(value, valueType);
            return new VecVectorImpl((String)value);
        }
        throw new IllegalStateException("Unhandled type: " + valueType);
    }

    private static void assertStringArg(Object value, ValueType valueType) {
        if (value instanceof String) {
            return;
        }
        throw new IllegalArgumentException("String value required to construct " + valueType);
    }

    private static class XdmVar
    implements XdmVariable {
        private final XName name;
        private final XdmValue value;

        public XdmVar(XName name, XdmValue value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public XName getName() {
            return this.name;
        }

        @Override
        public XdmValue getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof XdmVariable) {
                XdmVariable var = (XdmVariable)obj;
                return this.name.equals(var.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

