/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.io;

import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends InputStream {
    private InputStream stream;
    private int chunkSize;
    private int position;
    private boolean bof = true;
    private boolean eof = false;
    private boolean closed = false;

    public ChunkedInputStream(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream cannot be null");
        }
        this.stream = in;
        this.position = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.eof) {
            return -1;
        }
        if (this.position >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        ++this.position;
        return this.stream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Steam is closed");
        }
        if (this.eof) {
            return -1;
        }
        if (this.position >= this.chunkSize) {
            this.nextChunk();
            if (this.eof) {
                return -1;
            }
        }
        len = Math.min(len, this.chunkSize - this.position);
        int count = this.stream.read(b, off, len);
        this.position += count;
        return count;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void nextChunk() throws IOException {
        if (!this.bof) {
            this.decodeChunkTrailer();
        }
        this.decodeChunkHeader();
        this.bof = false;
        this.position = 0;
        if (this.chunkSize == 0) {
            this.eof = true;
        }
    }

    private void decodeChunkHeader() throws IOException {
        int len = 0;
        int ch = -1;
        block12: while (true) {
            ch = this.stream.read();
            switch (ch) {
                case -1: {
                    this.chunkSize = len;
                    return;
                }
                case 10: {
                    break block12;
                }
                case 13: {
                    continue block12;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    len = len * 16 + (ch - 48);
                    continue block12;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    len = len * 16 + (10 + ch - 97);
                    continue block12;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    len = len * 16 + (10 + ch - 65);
                    continue block12;
                }
                default: {
                    while (true) {
                        ch = this.stream.read();
                        switch (ch) {
                            case -1: {
                                this.chunkSize = len;
                                return;
                            }
                            case 10: {
                                break block12;
                            }
                        }
                    }
                }
            }
            break;
        }
        this.chunkSize = len;
        this.position = 0;
    }

    private void decodeChunkTrailer() throws IOException {
        int cr = this.stream.read();
        int lf = this.stream.read();
        if (cr != 13 || lf != 10) {
            throw new IOException("CRLF expected at end of chunk: " + cr + "/" + lf);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                if (!this.eof) {
                    byte[] buffer = new byte[1024];
                    while (this.stream.read(buffer) >= 0) {
                    }
                }
            }
            finally {
                this.eof = true;
                this.closed = true;
            }
        }
    }
}

